/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.Variable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.RatioOfTwoCollinearSegments;
import com.ogprover.pp.tp.auxiliary.RatioProduct;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SelfConditionalPoint;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GeneralizedSegmentDivisionPoint
extends SelfConditionalPoint {
    public static final String VERSION_NUM = "1.00";
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private Segment segment = null;
    private RatioProduct ratioProduct = null;
    private double multiplicatorCoefficient = 0.0;

    public void setSegment(Segment seg) {
        this.segment = seg;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public void setRatioProduct(RatioProduct ratioProduct) {
        this.ratioProduct = ratioProduct;
    }

    public RatioProduct getRatioProduct() {
        return this.ratioProduct;
    }

    public void setMultiplicatorCoefficient(double multiplicatorCoefficient) {
        this.multiplicatorCoefficient = multiplicatorCoefficient;
    }

    public double getMultiplicatorCoefficient() {
        return this.multiplicatorCoefficient;
    }

    @Override
    public int getConstructionType() {
        return 8;
    }

    @Override
    public SymbolicPolynomial getXCondition() {
        return null;
    }

    @Override
    public SymbolicPolynomial getYCondition() {
        return null;
    }

    public GeneralizedSegmentDivisionPoint(String pointLabel, Point A, Point B, RatioProduct ratioProd, double mulCoeff) {
        this.geoObjectLabel = pointLabel;
        if (A != null && B != null) {
            this.segment = new Segment(A, B);
        }
        this.ratioProduct = ratioProd != null ? ratioProd : new RatioProduct();
        this.multiplicatorCoefficient = mulCoeff;
    }

    @Override
    public Point clone() {
        GeneralizedSegmentDivisionPoint p = this.segment != null ? new GeneralizedSegmentDivisionPoint(this.geoObjectLabel, this.segment.getFirstEndPoint(), this.segment.getSecondEndPoint(), this.ratioProduct, this.multiplicatorCoefficient) : new GeneralizedSegmentDivisionPoint(this.geoObjectLabel, null, null, this.ratioProduct, this.multiplicatorCoefficient);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public XPolynomial instantiateXCondition(Map<String, Point> pointsMap) {
        Point A = this.segment.getFirstEndPoint();
        Point B = this.segment.getSecondEndPoint();
        Segment AM0Seg = new Segment(A, this);
        Segment M0BSeg = new Segment(this, B);
        XPolynomial AM0Poly = AM0Seg.getInstantiatedXCoordinateOfOrientedSegment();
        XPolynomial M0BPoly = M0BSeg.getInstantiatedXCoordinateOfOrientedSegment();
        UXVariable x_A = A.getX();
        UXVariable x_B = B.getX();
        if (((Variable)x_A).getVariableType() == ((Variable)x_B).getVariableType() && x_A.getIndex() == x_B.getIndex()) {
            return AM0Poly.reduceByUTermDivision();
        }
        this.ratioProduct.transformToAlgebraicForm();
        return ((XPolynomial)AM0Poly.multiplyByPolynomial(this.ratioProduct.getDenominator()).subtractPolynomial(M0BPoly.multiplyByPolynomial(this.ratioProduct.getNumerator()).multiplyByRealConstant(this.multiplicatorCoefficient))).reduceByUTermDivision();
    }

    @Override
    public XPolynomial instantiateYCondition(Map<String, Point> pointsMap) {
        Point A = this.segment.getFirstEndPoint();
        Point B = this.segment.getSecondEndPoint();
        Segment AM0Seg = new Segment(A, this);
        Segment M0BSeg = new Segment(this, B);
        XPolynomial AM0Poly = AM0Seg.getInstantiatedYCoordinateOfOrientedSegment();
        XPolynomial M0BPoly = M0BSeg.getInstantiatedYCoordinateOfOrientedSegment();
        UXVariable y_A = A.getY();
        UXVariable y_B = B.getY();
        if (((Variable)y_A).getVariableType() == ((Variable)y_B).getVariableType() && y_A.getIndex() == y_B.getIndex()) {
            return AM0Poly.reduceByUTermDivision();
        }
        this.ratioProduct.transformToAlgebraicForm();
        return ((XPolynomial)AM0Poly.multiplyByPolynomial(this.ratioProduct.getDenominator()).subtractPolynomial(M0BPoly.multiplyByPolynomial(this.ratioProduct.getNumerator()).multiplyByRealConstant(this.multiplicatorCoefficient))).reduceByUTermDivision();
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            if (this.segment == null || this.segment.getFirstEndPoint() == null || this.segment.getSecondEndPoint() == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Segment division point " + this.getGeoObjectLabel() + " can't be constructed since one or two segment's end points are not constructed");
                return false;
            }
            int indexA = this.segment.getFirstEndPoint().getIndex();
            int indexB = this.segment.getSecondEndPoint().getIndex();
            if (indexA < 0 || indexB < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Segment division point " + this.getGeoObjectLabel() + " can't be constructed since some of segment's end ponts is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexA && this.index > indexB;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Segment division point " + this.getGeoObjectLabel() + " can't be constructed since some of segment's end points is not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Generalized segment division point ");
        sb.append(this.geoObjectLabel);
        sb.append(" of segment ");
        sb.append(this.segment.getDescription());
        sb.append(" with respect to ratio product ");
        boolean bFirst = true;
        for (RatioOfTwoCollinearSegments ratio : this.ratioProduct.getRatios()) {
            if (!bFirst) {
                sb.append("*");
            } else {
                bFirst = false;
            }
            sb.append("(");
            sb.append(ratio.getNumeratorSegment().getDescription());
            sb.append("/");
            sb.append(ratio.getDenominatorSegment().getDescription());
            sb.append(")");
        }
        sb.append(" and coefficient ");
        sb.append(this.multiplicatorCoefficient);
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        String Alabel = this.segment.getFirstEndPoint().getGeoObjectLabel();
        String Blabel = this.segment.getSecondEndPoint().getGeoObjectLabel();
        labels.put(Alabel, Alabel);
        labels.put(Blabel, Blabel);
        for (RatioOfTwoCollinearSegments ratio : this.ratioProduct.getRatios()) {
            Segment numSeg = ratio.getNumeratorSegment();
            Segment denSeg = ratio.getDenominatorSegment();
            String A1label = numSeg.getFirstEndPoint().getGeoObjectLabel();
            String B1label = numSeg.getSecondEndPoint().getGeoObjectLabel();
            String A2label = denSeg.getFirstEndPoint().getGeoObjectLabel();
            String B2label = denSeg.getSecondEndPoint().getGeoObjectLabel();
            labels.put(A1label, A1label);
            labels.put(B1label, B1label);
            labels.put(A2label, A2label);
            labels.put(B2label, B2label);
        }
        String[] inputLabels = new String[labels.size()];
        int ii = 0;
        for (String label : labels.keySet()) {
            inputLabels[ii++] = label;
        }
        return inputLabels;
    }

    @Override
    public Map<String, Point> getPointsForInstantiation() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, this);
        pointsMap.put(ALabel, this.segment.getFirstEndPoint());
        pointsMap.put(BLabel, this.segment.getSecondEndPoint());
        return pointsMap;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        OpenGeoProver.settings.getLogger().error("This method should not be called on this class.");
        return null;
    }
}

