/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.geoobject.GeoObject;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;

public abstract class GeoConstruction
implements GeoObject {
    public static final String VERSION_NUM = "1.00";
    public static final int GEOCONS_TYPE_IGNORED = -2;
    public static final int GEOCONS_TYPE_UNDEFINED = -1;
    public static final int GEOCONS_TYPE_FREE_POINT = 0;
    public static final int GEOCONS_TYPE_MIDPOINT = 1;
    public static final int GEOCONS_TYPE_SEGMENT_RATIO = 2;
    public static final int GEOCONS_TYPE_HARMONIC_POINT = 3;
    public static final int GEOCONS_TYPE_CENTAL_SYMMETRIC_POINT = 4;
    public static final int GEOCONS_TYPE_TRANSLATED_POINT = 5;
    public static final int GEOCONS_TYPE_ROTATED_POINT = 6;
    public static final int GEOCONS_TYPE_INVERSE_POINT = 7;
    public static final int GEOCONS_TYPE_GEN_SEGMENT_RATIO = 8;
    public static final int GEOCONS_TYPE_AM_FOOT_POINT = 9;
    public static final int GEOCONS_TYPE_TRATIO_POINT = 10;
    public static final int GEOCONS_TYPE_PRATIO_POINT = 11;
    public static final int GEOCONS_TYPE_INTERSECTION = 20;
    public static final int GEOCONS_TYPE_AM_INTERSECTION_POINT = 21;
    public static final int GEOCONS_TYPE_RAND_POINT_ON_LINE = 30;
    public static final int GEOCONS_TYPE_RAND_POINT_ON_CIRCLE = 31;
    public static final int GEOCONS_TYPE_RAND_POINT_ON_CONIC = 32;
    public static final int GEOCONS_TYPE_LINE_THROUGH_TWO_POINTS = 40;
    public static final int GEOCONS_TYPE_PARALLEL = 41;
    public static final int GEOCONS_TYPE_PERPENDICULAR = 42;
    public static final int GEOCONS_TYPE_PERPENDICULAR_BISECTOR = 43;
    public static final int GEOCONS_TYPE_ANGLE_BISECTOR = 44;
    public static final int GEOCONS_TYPE_TANGENT = 45;
    public static final int GEOCONS_TYPE_RADICAL_AXIS = 46;
    public static final int GEOCONS_TYPE_ANGLE_RAY = 47;
    public static final int GEOCONS_TYPE_ANGLE_TRISECTOR = 48;
    public static final int GEOCONS_TYPE_TRIPLE_ANGLE_RAY = 49;
    public static final int GEOCONS_TYPE_ANGLE_RAY_TO_60_DEG = 50;
    public static final int GEOCONS_TYPE_CIRCLE_WITH_CENTER_AND_POINT = 60;
    public static final int GEOCONS_TYPE_CIRCLE_WITH_CENTER_AND_RADIUS = 61;
    public static final int GEOCONS_TYPE_CIRCLE_WITH_DIAMETER = 62;
    public static final int GEOCONS_TYPE_CIRCUMSCRIBED_CIRCLE = 63;
    public static final int GEOCONS_TYPE_CONIC_SECTION = 64;
    public static final int GEOCONS_TYPE_CONIC_SECTION_WITH_FIVE_PTS = 65;
    public static final int GEOCONS_TYPE_ANGLE_OF_60_DEG = 70;
    protected String geoObjectLabel = null;
    protected OGPTP consProtocol = null;
    protected int index = -1;

    public abstract int getConstructionType();

    public abstract String getConstructionDesc();

    public abstract String[] getInputLabels();

    public void setGeoObjectLabel(String geoObjectLabel) {
        this.geoObjectLabel = geoObjectLabel;
    }

    @Override
    public String getGeoObjectLabel() {
        return this.geoObjectLabel;
    }

    public void setConsProtocol(OGPTP consProtocol) {
        this.consProtocol = consProtocol;
    }

    public OGPTP getConsProtocol() {
        return this.consProtocol;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        try {
            if (this.consProtocol == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Object " + this.geoObjectLabel + " not assigned to theorem protocol.");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }
}

