/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SelfConditionalPoint;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HarmonicConjugatePoint
extends SelfConditionalPoint {
    public static final String VERSION_NUM = "1.00";
    private static SymbolicPolynomial xConditionForHarmonicPointGeneral;
    private static SymbolicPolynomial yConditionForHarmonicPointGeneral;
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private static final String CLabel = "C";
    private Point pointA = null;
    private Point pointB = null;
    private Point pointC = null;

    public void setPointA(Point A) {
        this.pointA = A;
    }

    public Point getPointA() {
        return this.pointA;
    }

    public void setPointB(Point B) {
        this.pointB = B;
    }

    public Point getPointB() {
        return this.pointB;
    }

    public void setPointC(Point C) {
        this.pointC = C;
    }

    public Point getPointC() {
        return this.pointC;
    }

    @Override
    public int getConstructionType() {
        return 3;
    }

    @Override
    public SymbolicPolynomial getXCondition() {
        if (this.pointA.getX().equals(this.pointB.getX())) {
            SymbolicPolynomial xCond = new SymbolicPolynomial();
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(new SymbolicVariable(2, ALabel), 1));
            xCond.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(new SymbolicVariable(2, M0Label), 1));
            xCond.addTerm(t);
            return xCond;
        }
        return xConditionForHarmonicPointGeneral;
    }

    @Override
    public SymbolicPolynomial getYCondition() {
        if (this.pointA.getY().equals(this.pointB.getY())) {
            SymbolicPolynomial yCond = new SymbolicPolynomial();
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(new SymbolicVariable(3, ALabel), 1));
            yCond.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(new SymbolicVariable(3, M0Label), 1));
            yCond.addTerm(t);
            return yCond;
        }
        return yConditionForHarmonicPointGeneral;
    }

    public HarmonicConjugatePoint(String pointLabel, Point A, Point B, Point C) {
        this.geoObjectLabel = pointLabel;
        this.pointA = A;
        this.pointB = B;
        this.pointC = C;
    }

    @Override
    public Point clone() {
        HarmonicConjugatePoint p = new HarmonicConjugatePoint(this.geoObjectLabel, this.pointA, this.pointB, this.pointC);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            if (this.pointA == null || this.pointB == null || this.pointC == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Harmonic conjugate point " + this.getGeoObjectLabel() + " can't be constructed since some point from triple of points is not constructed");
                return false;
            }
            int indexA = this.pointA.getIndex();
            int indexB = this.pointB.getIndex();
            int indexC = this.pointC.getIndex();
            if (indexA < 0 || indexB < 0 || indexC < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Harmonic conjugate point " + this.getGeoObjectLabel() + " can't be constructed since some point from triple of points is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexA && this.index > indexB && this.index > indexC;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Harmonic conjugate point " + this.getGeoObjectLabel() + " can't be constructed since some point from triple of points is not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fourth harmonic conjugate point ");
        sb.append(this.geoObjectLabel);
        sb.append(" of tripple of points ");
        sb.append(this.pointA.getGeoObjectLabel());
        sb.append(", ");
        sb.append(this.pointB.getGeoObjectLabel());
        sb.append(" and ");
        sb.append(this.pointC.getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.pointA.getGeoObjectLabel(), this.pointB.getGeoObjectLabel(), this.pointC.getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Map<String, Point> getPointsForInstantiation() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, this);
        pointsMap.put(ALabel, this.pointA);
        pointsMap.put(BLabel, this.pointB);
        pointsMap.put(CLabel, this.pointC);
        return pointsMap;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        OpenGeoProver.settings.getLogger().error("This method should not be called on this class.");
        return null;
    }

    static {
        SymbolicTerm t;
        xConditionForHarmonicPointGeneral = null;
        yConditionForHarmonicPointGeneral = null;
        if (xConditionForHarmonicPointGeneral == null) {
            xConditionForHarmonicPointGeneral = new SymbolicPolynomial();
            SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            SymbolicVariable xC = new SymbolicVariable(2, CLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(x0, 1));
            xConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(x0, 1));
            xConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(-2.0);
            t.addPower(new Power(xC, 1));
            t.addPower(new Power(x0, 1));
            xConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(xC, 1));
            xConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(xC, 1));
            xConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(-2.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(xB, 1));
            xConditionForHarmonicPointGeneral.addTerm(t);
        }
        if (yConditionForHarmonicPointGeneral == null) {
            yConditionForHarmonicPointGeneral = new SymbolicPolynomial();
            SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            SymbolicVariable yC = new SymbolicVariable(3, CLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(y0, 1));
            yConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yB, 1));
            t.addPower(new Power(y0, 1));
            yConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(-2.0);
            t.addPower(new Power(yC, 1));
            t.addPower(new Power(y0, 1));
            yConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(yC, 1));
            yConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yB, 1));
            t.addPower(new Power(yC, 1));
            yConditionForHarmonicPointGeneral.addTerm(t);
            t = new SymbolicTerm(-2.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(yB, 1));
            yConditionForHarmonicPointGeneral.addTerm(t);
        }
    }
}

