/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.XPolySystem;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.AMIntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;

public class IntersectionPoint
extends Point {
    public static final String VERSION_NUM = "1.00";
    private SetOfPoints firstPointSet = null;
    private SetOfPoints secondPointSet = null;

    @Override
    public int getConstructionType() {
        return 30;
    }

    public void setFirstPointSet(SetOfPoints firstSet) {
        this.firstPointSet = firstSet;
    }

    public SetOfPoints getFirstPointSet() {
        return this.firstPointSet;
    }

    public void setSecondPointSet(SetOfPoints secondSet) {
        this.secondPointSet = secondSet;
    }

    public SetOfPoints getSecondPointSet() {
        return this.secondPointSet;
    }

    public IntersectionPoint(String pointLabel, SetOfPoints firstSet, SetOfPoints secondSet) {
        this.geoObjectLabel = pointLabel;
        this.firstPointSet = firstSet;
        if (this.firstPointSet != null) {
            this.firstPointSet.addPointToSet(this);
        }
        this.secondPointSet = secondSet;
        if (this.secondPointSet != null) {
            this.secondPointSet.addPointToSet(this);
        }
    }

    @Override
    public Point clone() {
        IntersectionPoint p = new IntersectionPoint(this.geoObjectLabel, null, null);
        p.setFirstPointSet(this.firstPointSet);
        p.setSecondPointSet(this.secondPointSet);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            if (this instanceof AMIntersectionPoint) {
                return true;
            }
            if (this.firstPointSet == null || this.secondPointSet == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Intersection point " + this.getGeoObjectLabel() + " can't be constructed since some base points' set is not constructed");
                return false;
            }
            if (((GeoConstruction)((Object)this.firstPointSet)).getIndex() < 0 || ((GeoConstruction)((Object)this.firstPointSet)).getIndex() >= this.index || ((GeoConstruction)((Object)this.secondPointSet)).getIndex() < 0 || ((GeoConstruction)((Object)this.secondPointSet)).getIndex() >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Intersection point " + this.getGeoObjectLabel() + " can't be constructed since some base points' set is not yet constructed or not added to theorem protocol");
                return false;
            }
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
        return true;
    }

    @Override
    public int transformToAlgebraicForm() {
        return this.transformToAlgebraicFormWithOutputPrintFlag(true);
    }

    public int transformToAlgebraicFormWithOutputPrintFlag(boolean outputPrintFlag) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        try {
            PointSetRelationshipManager manager2;
            XPolynomial condition2;
            PointSetRelationshipManager manager1;
            XPolynomial condition1;
            if (outputPrintFlag) {
                output.openSubSection("Transformation of point " + this.geoObjectLabel + ": ", true);
                output.openEnum("itemize");
            }
            this.consProtocol.instantiatePoint(this, 3);
            if (outputPrintFlag) {
                output.openItem();
                output.writePointCoordinatesAssignment(this);
                output.closeItem();
            }
            if ((condition1 = (manager1 = new PointSetRelationshipManager(this.firstPointSet, this)).retrieveInstantiatedCondition()) == null) {
                logger.error("Failed to instantiate the first condition for this point");
                if (outputPrintFlag) {
                    output.closeEnum("itemize");
                    output.closeSubSection();
                }
                return -1;
            }
            if (outputPrintFlag) {
                output.openItem();
                output.writePlainText("Polynomial that point " + this.geoObjectLabel + " has to satisfy is:");
                output.writePolynomial(condition1);
                output.closeItem();
            }
            if (outputPrintFlag) {
                output.openItem();
            }
            int retCode1 = this.processConstructionPolynomial(condition1, outputPrintFlag);
            if (outputPrintFlag) {
                output.closeItem();
            }
            switch (retCode1) {
                case -1: 
                case 0: 
                case 1: {
                    logger.error("Error or bad polynomial instantiated when transforming to algebraic form");
                    if (outputPrintFlag) {
                        output.closeEnum("itemize");
                        output.openEnum("description");
                        output.openItemWithDesc("Error:");
                        output.closeItemWithDesc("Failed to process the condition");
                        output.closeEnum("description");
                        output.closeSubSection();
                    }
                    return -1;
                }
                case 3: {
                    logger.info("Renamed coordinates of point " + this.getGeoObjectLabel());
                    if (!outputPrintFlag) break;
                    output.openItem();
                    output.writePlainText("Point " + this.geoObjectLabel + " has been renamed. ");
                    output.writePointCoordinatesAssignment(this);
                    output.closeItem();
                    break;
                }
                case 2: {
                    logger.info("New polynomial condition added to system of hypotheses");
                    if (!outputPrintFlag) break;
                    output.openItem();
                    output.writePlainText("New polynomial added to system of hypotheses");
                    output.closeItem();
                    break;
                }
                default: {
                    logger.error("Unknown return result from processing of condition");
                    if (outputPrintFlag) {
                        output.closeEnum("itemize");
                        output.openEnum("description");
                        output.openItemWithDesc("Error:");
                        output.closeItemWithDesc("Failed to process the condition");
                        output.closeEnum("description");
                        output.closeSubSection();
                    }
                    return -1;
                }
            }
            if ((condition2 = (manager2 = new PointSetRelationshipManager(this.secondPointSet, this)).retrieveInstantiatedCondition()) == null) {
                logger.error("Failed to instantiate the second condition for this point");
                if (outputPrintFlag) {
                    output.closeEnum("itemize");
                    output.closeSubSection();
                }
                return -1;
            }
            if (outputPrintFlag) {
                output.openItem();
                output.writePlainText("Polynomial that point " + this.geoObjectLabel + " has to satisfy is:");
                output.writePolynomial(condition2);
                output.closeItem();
            }
            if (outputPrintFlag) {
                output.openItem();
            }
            int retCode2 = this.processConstructionPolynomial(condition2, outputPrintFlag);
            if (outputPrintFlag) {
                output.closeItem();
            }
            switch (retCode2) {
                case -1: 
                case 0: 
                case 1: {
                    logger.error("Error or bad polynomial instantiated when transforming to algebraic form");
                    if (outputPrintFlag) {
                        output.closeEnum("itemize");
                        output.openEnum("description");
                        output.openItemWithDesc("Error:");
                        output.closeItemWithDesc("Failed to process the condition");
                        output.closeEnum("description");
                        output.closeSubSection();
                    }
                    return -1;
                }
                case 3: {
                    logger.info("Renamed coordinates of point " + this.getGeoObjectLabel());
                    if (!outputPrintFlag) break;
                    output.openItem();
                    output.writePlainText("Point " + this.geoObjectLabel + " has been renamed. ");
                    output.writePointCoordinatesAssignment(this);
                    output.closeItem();
                    break;
                }
                case 2: {
                    logger.info("New polynomial condition added to system of hypotheses");
                    if (!outputPrintFlag) break;
                    output.openItem();
                    output.writePlainText("New polynomial added to system of hypotheses");
                    output.closeItem();
                    break;
                }
                default: {
                    logger.error("Unknown return result from processing of condition");
                    if (outputPrintFlag) {
                        output.closeEnum("itemize");
                        output.openEnum("description");
                        output.openItemWithDesc("Error:");
                        output.closeItemWithDesc("Failed to process the condition");
                        output.closeEnum("description");
                        output.closeSubSection();
                    }
                    return -1;
                }
            }
            if (retCode2 == 3 && retCode1 == 2) {
                XPolySystem system = this.consProtocol.getAlgebraicGeoTheorem().getHypotheses();
                system.removePoly(system.getPolynomials().size() - 1);
                if (outputPrintFlag) {
                    output.openItem();
                    output.writePlainText("Repeating instantiation of first condition of this point, after its coordinate has been renamed");
                    output.closeItem();
                }
                manager1.setPoint(this);
                condition1 = manager1.retrieveInstantiatedCondition();
                if (outputPrintFlag) {
                    output.openItem();
                    output.writePlainText("Polynomial that point " + this.geoObjectLabel + " has to satisfy is:");
                    output.writePolynomial(condition1);
                    output.closeItem();
                }
                if (condition1 == null) {
                    logger.error("Failed to instantiate the first condition for this point");
                    if (outputPrintFlag) {
                        output.closeEnum("itemize");
                        output.closeSubSection();
                    }
                    return -1;
                }
                if (outputPrintFlag) {
                    output.openItem();
                }
                retCode1 = this.processConstructionPolynomial(condition1, outputPrintFlag);
                if (outputPrintFlag) {
                    output.closeItem();
                }
                switch (retCode1) {
                    case -1: 
                    case 0: 
                    case 1: {
                        logger.error("Error or bad polynomial instantiated when transforming to algebraic form");
                        if (outputPrintFlag) {
                            output.closeEnum("itemize");
                            output.openEnum("description");
                            output.openItemWithDesc("Error:");
                            output.closeItemWithDesc("Failed to process the condition");
                            output.closeEnum("description");
                            output.closeSubSection();
                        }
                        return -1;
                    }
                    case 3: {
                        logger.info("Renamed coordinates of point " + this.getGeoObjectLabel());
                        if (!outputPrintFlag) break;
                        output.openItem();
                        output.writePlainText("Point " + this.geoObjectLabel + " has been renamed. ");
                        output.writePointCoordinatesAssignment(this);
                        output.closeItem();
                        break;
                    }
                    case 2: {
                        logger.info("New polynomial condition added to system of hypotheses");
                        if (!outputPrintFlag) break;
                        output.openItem();
                        output.writePlainText("New polynomial added to system of hypotheses");
                        output.closeItem();
                        break;
                    }
                    default: {
                        logger.error("Unknown return result from processing of condition");
                        if (outputPrintFlag) {
                            output.closeEnum("itemize");
                            output.openEnum("description");
                            output.openItemWithDesc("Error:");
                            output.closeItemWithDesc("Failed to process the condition");
                            output.closeEnum("description");
                            output.closeSubSection();
                        }
                        return -1;
                    }
                }
            }
            if (outputPrintFlag) {
                output.closeEnum("itemize");
                output.closeSubSection();
            }
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Intersection point ");
        sb.append(this.geoObjectLabel);
        sb.append(" of point sets ");
        sb.append(((GeoConstruction)((Object)this.firstPointSet)).getGeoObjectLabel());
        sb.append(" and ");
        sb.append(((GeoConstruction)((Object)this.secondPointSet)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{((GeoConstruction)((Object)this.firstPointSet)).getGeoObjectLabel(), ((GeoConstruction)((Object)this.secondPointSet)).getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        if (this instanceof AMIntersectionPoint) {
            return ((AMIntersectionPoint)this).replace(replacementMap);
        }
        OpenGeoProver.settings.getLogger().error("This method should not be called on this class.");
        return null;
    }
}

