/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SelfConditionalPoint;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class InverseOfPoint
extends SelfConditionalPoint {
    public static final String VERSION_NUM = "1.00";
    private static SymbolicPolynomial xConditionForInverseOfPointGeneral;
    private static SymbolicPolynomial yConditionForInverseOfPointGeneral;
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String OLabel = "O";
    private static final String BLabel = "B";
    private Point originalPoint = null;
    private Circle circleOfInversion = null;
    private Point secantPoint = null;

    public void setOriginalPoint(Point origP) {
        this.originalPoint = origP;
    }

    public Point getOriginalPoint() {
        return this.originalPoint;
    }

    public void setCircleOfInversion(Circle circle) {
        this.circleOfInversion = circle;
    }

    public Circle getCircleOfInversion() {
        return this.circleOfInversion;
    }

    public void setSecantPoint(Point intersectP) {
        this.secantPoint = intersectP;
    }

    public Point getSecantPoint() {
        return this.secantPoint;
    }

    @Override
    public int getConstructionType() {
        return 7;
    }

    @Override
    public SymbolicPolynomial getXCondition() {
        if (this.circleOfInversion.getCenter().getX().equals(this.originalPoint.getX())) {
            SymbolicPolynomial xCond = new SymbolicPolynomial();
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(new SymbolicVariable(2, ALabel), 1));
            xCond.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(new SymbolicVariable(2, M0Label), 1));
            xCond.addTerm(t);
            return xCond;
        }
        return xConditionForInverseOfPointGeneral;
    }

    @Override
    public SymbolicPolynomial getYCondition() {
        if (this.circleOfInversion.getCenter().getY().equals(this.originalPoint.getY())) {
            SymbolicPolynomial yCond = new SymbolicPolynomial();
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(new SymbolicVariable(3, ALabel), 1));
            yCond.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(new SymbolicVariable(3, M0Label), 1));
            yCond.addTerm(t);
            return yCond;
        }
        return yConditionForInverseOfPointGeneral;
    }

    public InverseOfPoint(String pointLabel, Point A, Circle invC) {
        this.geoObjectLabel = pointLabel;
        this.originalPoint = A;
        this.circleOfInversion = invC;
    }

    @Override
    public Point clone() {
        InverseOfPoint p = new InverseOfPoint(this.geoObjectLabel, this.originalPoint, this.circleOfInversion);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            if (this.originalPoint == null || this.circleOfInversion == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Inverse point " + this.getGeoObjectLabel() + " can't be constructed since original point or circle of inversion are not constructed");
                return false;
            }
            int indexA = this.originalPoint.getIndex();
            int indexC = this.circleOfInversion.getIndex();
            if (indexA < 0 || indexC < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Inverse point " + this.getGeoObjectLabel() + " can't be constructed since original point or circle of inversion are not added to theorem protocol");
                return false;
            }
            if (this.index <= indexA || this.index <= indexC) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Inverse point " + this.getGeoObjectLabel() + " can't be constructed since original point or circle of inversion are not yet constructed");
                return false;
            }
            Point centerP = this.circleOfInversion.getCenter();
            if (centerP == null || centerP.getIndex() < 0 || centerP.getIndex() >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Inverse point " + this.getGeoObjectLabel() + " can't be constructed since circle of inversion still doesn't have constructed center");
                return false;
            }
            Vector<Point> circlePoints = this.circleOfInversion.getPoints();
            block2: for (GeoConstruction geoCons : this.consProtocol.getConstructionSteps()) {
                Line l;
                Vector<Point> lPoints;
                if (!(geoCons instanceof Line) || (lPoints = (l = (Line)geoCons).getPoints()).indexOf(centerP) <= 0 || lPoints.indexOf(this.originalPoint) <= 0) continue;
                for (Point p : lPoints) {
                    if (p.getIndex() >= this.index || circlePoints.indexOf(p) <= 0) continue;
                    this.secantPoint = p;
                    continue block2;
                }
            }
            if (this.secantPoint == null) {
                LineThroughTwoPoints secantLine = new LineThroughTwoPoints("secantLine" + Math.round(Math.random() * 1000.0), this.circleOfInversion.getCenter(), this.originalPoint);
                IntersectionPoint secantP = new IntersectionPoint("secantPoint" + Math.round(Math.random() * 1000.0), this.circleOfInversion, secantLine);
                this.consProtocol.addGeoConstruction(this.getIndex(), secantLine);
                if (!((GeoConstruction)secantLine).isValidConstructionStep()) {
                    output.openItemWithDesc("Error: ");
                    output.closeItemWithDesc("Inverse point " + this.getGeoObjectLabel() + " can't be constructed since construction of secant point is invalid");
                    return false;
                }
                this.consProtocol.addGeoConstruction(secantLine.getIndex() + 1, secantP);
                if (!((GeoConstruction)secantP).isValidConstructionStep()) {
                    output.openItemWithDesc("Error: ");
                    output.closeItemWithDesc("Inverse point " + this.getGeoObjectLabel() + " can't be constructed since construction of secant point is invalid");
                    return false;
                }
                this.secantPoint = secantP;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Inverse point ");
        sb.append(this.geoObjectLabel);
        sb.append(" of point ");
        sb.append(this.originalPoint.getGeoObjectLabel());
        sb.append(" with respect to circle ");
        sb.append(this.circleOfInversion.getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.originalPoint.getGeoObjectLabel(), this.circleOfInversion.getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Map<String, Point> getPointsForInstantiation() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, this);
        pointsMap.put(ALabel, this.originalPoint);
        pointsMap.put(BLabel, this.secantPoint);
        pointsMap.put(OLabel, this.circleOfInversion.getCenter());
        return pointsMap;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        OpenGeoProver.settings.getLogger().error("This method should not be called on this class.");
        return null;
    }

    static {
        SymbolicTerm t;
        xConditionForInverseOfPointGeneral = null;
        yConditionForInverseOfPointGeneral = null;
        if (xConditionForInverseOfPointGeneral == null) {
            xConditionForInverseOfPointGeneral = new SymbolicPolynomial();
            SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
            SymbolicVariable xO = new SymbolicVariable(2, OLabel);
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(x0, 1));
            xConditionForInverseOfPointGeneral.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xO, 1));
            t.addPower(new Power(x0, 1));
            xConditionForInverseOfPointGeneral.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(xO, 1));
            xConditionForInverseOfPointGeneral.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xB, 2));
            xConditionForInverseOfPointGeneral.addTerm(t);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(xO, 1));
            xConditionForInverseOfPointGeneral.addTerm(t);
        }
        if (yConditionForInverseOfPointGeneral == null) {
            yConditionForInverseOfPointGeneral = new SymbolicPolynomial();
            SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
            SymbolicVariable yO = new SymbolicVariable(3, OLabel);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(y0, 1));
            yConditionForInverseOfPointGeneral.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yO, 1));
            t.addPower(new Power(y0, 1));
            yConditionForInverseOfPointGeneral.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(yO, 1));
            yConditionForInverseOfPointGeneral.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yB, 2));
            yConditionForInverseOfPointGeneral.addTerm(t);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(yB, 1));
            t.addPower(new Power(yO, 1));
            yConditionForInverseOfPointGeneral.addTerm(t);
        }
    }
}

