/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.utilities.logger.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class Line
extends GeoConstruction
implements SetOfPoints {
    public static final String VERSION_NUM = "1.00";
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    protected Vector<Point> points = new Vector();

    public void setPoints(Vector<Point> points) {
        this.points = points;
    }

    @Override
    public Vector<Point> getPoints() {
        return this.points;
    }

    public XPolynomial instantiateCondition(Map<String, Point> pointsMap) {
        return OGPTP.instantiateCondition(this.getCondition(), pointsMap);
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        manager.prepareForFirstInstantiation();
        if (manager.isErrorFlag()) {
            logger.error("Failed in preparation method");
            return -1;
        }
        manager.setCondition(LineThroughTwoPoints.conditionForPlainLine);
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        Point P = manager.getPoint();
        pointsMap.put(M0Label, P);
        int jA = this.points.size();
        for (int iA = 0; iA < jA; ++iA) {
            Point pointA = this.points.get(iA);
            if (pointA.getIndex() >= P.getIndex()) continue;
            int jB = this.points.size();
            for (int iB = 0; iB < jB; ++iB) {
                Point pointB = this.points.get(iB);
                if (pointB.getIndex() >= P.getIndex() || pointB.getIndex() == pointA.getIndex()) continue;
                pointsMap.put(ALabel, pointA);
                pointsMap.put(BLabel, pointB);
                manager.processPointsAndCondition(pointsMap);
                if (manager.isErrorFlag()) {
                    logger.error("Failed in processing specific condition for plain line i.e. line through two points.");
                    return -1;
                }
                if (manager.getPoint().getPointState() != 3) continue;
                return 0;
            }
        }
        return 0;
    }

    @Override
    public void addPointToSet(Point P) {
        this.points.add(P);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        HashMap<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = new HashMap<SymbolicPolynomial, ArrayList<Map<String, Point>>>();
        if (this.points.size() < 2) {
            return retMap;
        }
        ArrayList allMappings = new ArrayList();
        HashMap<String, Point> pointsMap = null;
        for (Point A : this.points) {
            for (Point B : this.points) {
                if (B.getGeoObjectLabel().equals(A.getGeoObjectLabel())) continue;
                pointsMap = new HashMap<String, Point>();
                pointsMap.put(ALabel, A);
                pointsMap.put(BLabel, B);
                allMappings.add(pointsMap);
            }
        }
        retMap.put((SymbolicPolynomial)LineThroughTwoPoints.conditionForPlainLine.clone(), allMappings);
        return retMap;
    }
}

