/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class LineThroughTwoPoints
extends Line {
    public static final String VERSION_NUM = "1.00";
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    public static SymbolicPolynomial conditionForPlainLine = null;

    @Override
    public int getConstructionType() {
        return 40;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForPlainLine;
    }

    public LineThroughTwoPoints(String lineLabel, Point pointA, Point pointB) {
        this.geoObjectLabel = lineLabel;
        this.points = new Vector();
        if (pointA != null) {
            this.points.add(pointA);
        }
        if (pointB != null) {
            this.points.add(pointB);
        }
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            Point pointA = (Point)this.points.get(0);
            Point pointB = (Point)this.points.get(1);
            if (pointA == null || pointB == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Line " + this.getGeoObjectLabel() + " can't be constructed because some of its base points is not constructed");
                return false;
            }
            int indexA = pointA.getIndex();
            int indexB = pointB.getIndex();
            if (indexA < 0 || indexB < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Line " + this.getGeoObjectLabel() + " can't be constructed because some of its base points is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexA && this.index > indexB;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Line " + this.getGeoObjectLabel() + " can't be constructed because some of its base points is not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        return super.findBestPointsForInstantation(manager);
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(ALabel, (Point)this.points.get(0));
        pointsMap.put(BLabel, (Point)this.points.get(1));
        return this.instantiateCondition(pointsMap);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        return super.getAllPossibleConditionsWithMappings();
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Line ");
        sb.append(this.geoObjectLabel);
        sb.append(" through two points ");
        sb.append(((Point)this.points.get(0)).getGeoObjectLabel());
        sb.append(" and ");
        sb.append(((Point)this.points.get(1)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{((Point)this.points.get(0)).getGeoObjectLabel(), ((Point)this.points.get(1)).getGeoObjectLabel()};
        return inputLabels;
    }

    static {
        if (conditionForPlainLine == null) {
            conditionForPlainLine = new SymbolicPolynomial();
            SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
            SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(x0, 1));
            t.addPower(new Power(yB, 1));
            conditionForPlainLine.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(x0, 1));
            t.addPower(new Power(yA, 1));
            conditionForPlainLine.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(yB, 1));
            conditionForPlainLine.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(y0, 1));
            conditionForPlainLine.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(yA, 1));
            conditionForPlainLine.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(y0, 1));
            conditionForPlainLine.addTerm(t);
        }
    }
}

