/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SelfConditionalPoint;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MidPoint
extends SelfConditionalPoint {
    public static final String VERSION_NUM = "1.00";
    private static SymbolicPolynomial xConditionForMidPoint;
    private static SymbolicPolynomial yConditionForMidPoint;
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private Segment segment = null;

    public void setSegment(Segment seg) {
        this.segment = seg;
    }

    public Segment getSegment() {
        return this.segment;
    }

    @Override
    public int getConstructionType() {
        return 1;
    }

    @Override
    public SymbolicPolynomial getXCondition() {
        return xConditionForMidPoint;
    }

    @Override
    public SymbolicPolynomial getYCondition() {
        return yConditionForMidPoint;
    }

    public MidPoint(String pointLabel, Point A, Point B) {
        this.geoObjectLabel = pointLabel;
        if (A != null && B != null) {
            this.segment = new Segment(A, B);
        }
    }

    @Override
    public Point clone() {
        MidPoint p = new MidPoint(this.geoObjectLabel, this.segment.getFirstEndPoint(), this.segment.getSecondEndPoint());
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            if (this.segment == null || this.segment.getFirstEndPoint() == null || this.segment.getSecondEndPoint() == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Middle point " + this.getGeoObjectLabel() + " can't be constructed since one or two segment's end points are not constructed");
                return false;
            }
            int indexA = this.segment.getFirstEndPoint().getIndex();
            int indexB = this.segment.getSecondEndPoint().getIndex();
            if (indexA < 0 || indexB < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Middle point " + this.getGeoObjectLabel() + " can't be constructed since some of segment's end ponts is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexA && this.index > indexB;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Middle point " + this.getGeoObjectLabel() + " can't be constructed since some of segment's end points is not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Midpoint ");
        sb.append(this.geoObjectLabel);
        sb.append(" of segment ");
        sb.append(this.segment.getDescription());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.segment.getFirstEndPoint().getGeoObjectLabel(), this.segment.getSecondEndPoint().getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Map<String, Point> getPointsForInstantiation() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, this);
        pointsMap.put(ALabel, this.segment.getFirstEndPoint());
        pointsMap.put(BLabel, this.segment.getSecondEndPoint());
        return pointsMap;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        OpenGeoProver.settings.getLogger().error("This method should not be called on this class.");
        return null;
    }

    static {
        SymbolicTerm t;
        xConditionForMidPoint = null;
        yConditionForMidPoint = null;
        if (xConditionForMidPoint == null) {
            xConditionForMidPoint = new SymbolicPolynomial();
            SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(x0, 1));
            xConditionForMidPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 1));
            xConditionForMidPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xB, 1));
            xConditionForMidPoint.addTerm(t);
        }
        if (yConditionForMidPoint == null) {
            yConditionForMidPoint = new SymbolicPolynomial();
            SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(y0, 1));
            yConditionForMidPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yA, 1));
            yConditionForMidPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yB, 1));
            yConditionForMidPoint.addTerm(t);
        }
    }
}

