/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromLine;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ParallelLine
extends Line {
    public static final String VERSION_NUM = "1.00";
    public static SymbolicPolynomial conditionForParallelLine = null;
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private static final String CLabel = "C";
    private Line baseLine;

    @Override
    public int getConstructionType() {
        return 41;
    }

    public void setBaseLine(Line line) {
        this.baseLine = line;
    }

    public Line getBaseLine() {
        return this.baseLine;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForParallelLine;
    }

    public ParallelLine(String lineLabel, Line baseLine, Point pointC) {
        this.geoObjectLabel = lineLabel;
        this.points = new Vector();
        if (pointC != null) {
            this.points.add(pointC);
        }
        if (baseLine != null) {
            this.baseLine = baseLine;
        }
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            Point pointC = (Point)this.points.get(0);
            if (pointC == null || this.baseLine == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct parallel line " + this.getGeoObjectLabel() + " because its base line or point that it is passing through are not constructed");
                return false;
            }
            int indexC = pointC.getIndex();
            int indexLine = this.baseLine.getIndex();
            if (indexC < 0 || indexLine < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct parallel line " + this.getGeoObjectLabel() + " because its base line or point that it is passing through are not added to theorem protocol");
                return false;
            }
            if (indexC >= this.index || indexLine >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct parallel line " + this.getGeoObjectLabel() + " because its base line or point that it is passing through are not yet constructed");
                return false;
            }
            Point secondPoint = null;
            if (this.baseLine.getPoints().size() > 1) {
                secondPoint = this.baseLine.getPoints().get(1);
            }
            int minIdx = -1;
            int jj = this.points.size();
            for (int ii = 1; ii < jj; ++ii) {
                Point pt = (Point)this.points.get(ii);
                int ptIdx = pt.getIndex();
                if (ptIdx >= minIdx && ii != 1) continue;
                minIdx = ptIdx;
            }
            if (secondPoint == null || secondPoint.getIndex() < 0 || minIdx > -1 && secondPoint.getIndex() >= minIdx) {
                RandomPointFromLine rndOnParaBaseLine = new RandomPointFromLine("tempPoint-" + Math.round(Math.random() * 1000.0) + this.baseLine.getGeoObjectLabel(), this.baseLine);
                output.openItemWithDesc("Info: ");
                output.closeItemWithDesc("Attempting to add the construction of new random point " + rndOnParaBaseLine.getGeoObjectLabel() + " necessary for completion of construction of line " + this.getGeoObjectLabel());
                this.consProtocol.addGeoConstruction(minIdx > -1 ? minIdx : this.baseLine.getIndex() + 1, rndOnParaBaseLine);
                if (!rndOnParaBaseLine.isValidConstructionStep()) {
                    return false;
                }
                output.openItemWithDesc("Warrning: ");
                StringBuilder sb = new StringBuilder();
                sb.append("Generated new random point ");
                sb.append(rndOnParaBaseLine.getGeoObjectLabel());
                sb.append(" on line ");
                sb.append(this.baseLine.getGeoObjectLabel());
                sb.append(" in order to complete the construction of parallel line ");
                sb.append(this.getGeoObjectLabel());
                output.closeItemWithDesc(sb.toString());
            }
            return true;
        }
        catch (NullPointerException e) {
            logger.error("Parallel line verified as correctly constructed, but some elements are null");
            try {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Unexpected error has occured during validity check for construction of parallel line " + this.getGeoObjectLabel());
            }
            catch (IOException e1) {
                logger.error("Failed to write to output file(s).");
                output.close();
            }
            return false;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        super.findBestPointsForInstantation(manager);
        if (manager.isErrorFlag()) {
            logger.error("Failed in findBestPointsForInstantation() method from superclass");
            return -1;
        }
        if (manager.getPoint().getPointState() == 3) {
            return 0;
        }
        manager.getPoint().setPointState(4);
        manager.setCondition(this.getCondition());
        Point P = manager.getPoint();
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        int jA = this.baseLine.points.size();
        for (int iA = 0; iA < jA; ++iA) {
            Point pointA = this.baseLine.points.get(iA);
            if (pointA.getIndex() > P.getIndex()) continue;
            int jB = this.baseLine.points.size();
            for (int iB = 0; iB < jB; ++iB) {
                Point pointB = this.baseLine.points.get(iB);
                if (pointB.getIndex() > P.getIndex() || pointB.getIndex() <= pointA.getIndex()) continue;
                int jC = this.points.size();
                for (int iC = 0; iC < jC; ++iC) {
                    Point pointC = (Point)this.points.get(iC);
                    if (pointC.getIndex() >= P.getIndex()) continue;
                    pointsMap.put(ALabel, pointA);
                    pointsMap.put(BLabel, pointB);
                    pointsMap.put(CLabel, pointC);
                    manager.processPointsAndCondition(pointsMap);
                    if (manager.isErrorFlag()) {
                        logger.error("findBestPointsForInstantation() method failed in processing condition for parallel line");
                        return -1;
                    }
                    if (manager.getPoint().getPointState() != 3) continue;
                    return 0;
                }
            }
        }
        return 0;
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(ALabel, this.baseLine.points.get(0));
        pointsMap.put(BLabel, this.baseLine.points.get(1));
        pointsMap.put(CLabel, (Point)this.points.get(0));
        return this.instantiateCondition(pointsMap);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = super.getAllPossibleConditionsWithMappings();
        ArrayList allMappings = new ArrayList();
        HashMap<String, Point> pointsMap = null;
        for (Point A : this.baseLine.getPoints()) {
            for (Point B : this.baseLine.getPoints()) {
                if (B.getIndex() <= A.getIndex()) continue;
                for (Point C : this.points) {
                    pointsMap = new HashMap<String, Point>();
                    pointsMap.put(ALabel, A);
                    pointsMap.put(BLabel, B);
                    pointsMap.put(CLabel, C);
                    allMappings.add(pointsMap);
                }
            }
        }
        retMap.put((SymbolicPolynomial)conditionForParallelLine.clone(), allMappings);
        return retMap;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Line ");
        sb.append(this.geoObjectLabel);
        sb.append(" through point ");
        sb.append(((Point)this.points.get(0)).getGeoObjectLabel());
        sb.append(" parallel with line ");
        sb.append(this.baseLine.getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] strArr = new String[]{};
        ArrayList<String> inputLabels = new ArrayList<String>();
        Point firstPt = (Point)this.points.get(0);
        inputLabels.add(firstPt.getGeoObjectLabel());
        inputLabels.add(this.baseLine.getGeoObjectLabel());
        for (Point pt : this.baseLine.getPoints()) {
            String[] ptInputLabels = pt.getInputLabels();
            Vector<String> ptInputLabelsV = new Vector<String>();
            if (ptInputLabels != null) {
                for (String label : ptInputLabels) {
                    if (ptInputLabelsV.indexOf(label) != -1) continue;
                    ptInputLabelsV.add(label);
                }
            }
            boolean bDependent = false;
            while (ptInputLabelsV != null && ptInputLabelsV.size() > 0) {
                if (ptInputLabelsV.indexOf(this.getGeoObjectLabel()) != -1) {
                    bDependent = true;
                    break;
                }
                Vector<String> tempV = new Vector<String>();
                for (String label : ptInputLabelsV) {
                    String[] inLabels = this.consProtocol.getConstructionMap().get(label).getInputLabels();
                    if (inLabels == null) continue;
                    for (String label2 : inLabels) {
                        if (tempV.indexOf(label2) != -1) continue;
                        tempV.add(label2);
                    }
                }
                ptInputLabelsV = tempV;
            }
            if (bDependent || pt.equals(firstPt)) continue;
            inputLabels.add(pt.getGeoObjectLabel());
        }
        return inputLabels.toArray(strArr);
    }

    static {
        if (conditionForParallelLine == null) {
            conditionForParallelLine = new SymbolicPolynomial();
            SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
            SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            SymbolicVariable xC = new SymbolicVariable(2, CLabel);
            SymbolicVariable yC = new SymbolicVariable(3, CLabel);
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(y0, 1));
            conditionForParallelLine.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(yC, 1));
            conditionForParallelLine.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(y0, 1));
            conditionForParallelLine.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(yC, 1));
            conditionForParallelLine.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yB, 1));
            t.addPower(new Power(x0, 1));
            conditionForParallelLine.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yB, 1));
            t.addPower(new Power(xC, 1));
            conditionForParallelLine.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(x0, 1));
            conditionForParallelLine.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(xC, 1));
            conditionForParallelLine.addTerm(t);
        }
    }
}

