/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class PerpendicularBisector
extends Line {
    public static final String VERSION_NUM = "1.00";
    public static SymbolicPolynomial conditionForPerpendicularBisector = null;
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private Segment segment;

    @Override
    public int getConstructionType() {
        return 43;
    }

    public void setSegment(Segment seg) {
        this.segment = seg;
    }

    public Segment getSegment() {
        return this.segment;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForPerpendicularBisector;
    }

    public PerpendicularBisector(String lineLabel, Point pointA, Point pointB) {
        this.geoObjectLabel = lineLabel;
        this.points = new Vector();
        if (pointA != null && pointB != null) {
            this.segment = new Segment(pointA, pointB);
        }
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            if (this.segment == null || this.segment.getFirstEndPoint() == null || this.segment.getSecondEndPoint() == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct perpendicular bisector " + this.getGeoObjectLabel() + " because some of segment's end points is not constructed");
                return false;
            }
            int indexA = this.segment.getFirstEndPoint().getIndex();
            int indexB = this.segment.getSecondEndPoint().getIndex();
            if (indexA < 0 || indexB < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct perpendicular bisector " + this.getGeoObjectLabel() + " because some of segment's end points is not added to theorem protocol");
                return false;
            }
            if (indexA >= this.index || indexB >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct perpendicular bisector " + this.getGeoObjectLabel() + " because some of segment's end points is not yet constructed");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        super.findBestPointsForInstantation(manager);
        if (manager.isErrorFlag()) {
            logger.error("Failed in findBestPointsForInstantation() method from superclass");
            return -1;
        }
        if (manager.getPoint().getPointState() == 3) {
            return 0;
        }
        manager.getPoint().setPointState(4);
        manager.setCondition(this.getCondition());
        Point P = manager.getPoint();
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(ALabel, this.segment.getFirstEndPoint());
        pointsMap.put(BLabel, this.segment.getSecondEndPoint());
        manager.processPointsAndCondition(pointsMap);
        if (manager.isErrorFlag()) {
            logger.error("findBestPointsForInstantation() method failed in processing condition for perpendicular line");
            return -1;
        }
        return 0;
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(ALabel, this.segment.getFirstEndPoint());
        pointsMap.put(BLabel, this.segment.getSecondEndPoint());
        return this.instantiateCondition(pointsMap);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = super.getAllPossibleConditionsWithMappings();
        ArrayList allMappings = new ArrayList();
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, this.segment.getFirstEndPoint());
        pointsMap.put(BLabel, this.segment.getSecondEndPoint());
        allMappings.add(pointsMap);
        retMap.put((SymbolicPolynomial)conditionForPerpendicularBisector.clone(), allMappings);
        return retMap;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Perpendicular bisector ");
        sb.append(this.geoObjectLabel);
        sb.append(" of segment ");
        sb.append(this.segment.getDescription());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.segment.getFirstEndPoint().getGeoObjectLabel(), this.segment.getSecondEndPoint().getGeoObjectLabel()};
        return inputLabels;
    }

    static {
        if (conditionForPerpendicularBisector == null) {
            conditionForPerpendicularBisector = new SymbolicPolynomial();
            SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
            SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 2));
            conditionForPerpendicularBisector.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xB, 2));
            conditionForPerpendicularBisector.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yA, 2));
            conditionForPerpendicularBisector.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yB, 2));
            conditionForPerpendicularBisector.addTerm(t);
            t = new SymbolicTerm(-2.0);
            t.addPower(new Power(x0, 1));
            t.addPower(new Power(xA, 1));
            conditionForPerpendicularBisector.addTerm(t);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(x0, 1));
            t.addPower(new Power(xB, 1));
            conditionForPerpendicularBisector.addTerm(t);
            t = new SymbolicTerm(-2.0);
            t.addPower(new Power(y0, 1));
            t.addPower(new Power(yA, 1));
            conditionForPerpendicularBisector.addTerm(t);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(y0, 1));
            t.addPower(new Power(yB, 1));
            conditionForPerpendicularBisector.addTerm(t);
        }
    }
}

