/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.Term;
import com.ogprover.polynomials.UFraction;
import com.ogprover.polynomials.UPolynomial;
import com.ogprover.polynomials.UTerm;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.polynomials.XTerm;
import com.ogprover.pp.tp.expressions.RatioOfCollinearSegments;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class Point
extends GeoConstruction
implements Cloneable {
    public static final String VERSION_NUM = "1.00";
    protected UXVariable X = null;
    protected UXVariable Y = null;
    public static final int POINT_TYPE_NONE = -1;
    public static final int POINT_TYPE_FREE = 0;
    public static final int POINT_TYPE_X_INDEPENDENT = 1;
    public static final int POINT_TYPE_Y_INDEPENDENT = 2;
    public static final int POINT_TYPE_DEPENDENT = 3;
    protected int instanceType = -1;
    public static final int PROCESSPOLY_RETCODE_BAD_POLYNOMIAL = 0;
    public static final int PROCESSPOLY_RETCODE_TRY_AGAIN = 1;
    public static final int PROCESSPOLY_RETCODE_ADDED_TO_SYSTEM = 2;
    public static final int PROCESSPOLY_RETCODE_COORDINATES_RENAMED = 3;
    public static final int POINT_STATE_INITIALIZED = 0;
    public static final int POINT_STATE_INSTANTIATED = 1;
    public static final int POINT_STATE_REINSTANTIATED = 2;
    public static final int POINT_STATE_RENAMED = 3;
    public static final int POINT_STATE_UNCHANGED = 4;
    protected int pointState = 0;
    protected HashMap<String, RatioOfCollinearSegments> distances;

    public abstract int transformToAlgebraicForm();

    public abstract Point clone();

    public abstract Point replace(HashMap<Point, Point> var1);

    public void setX(UXVariable x) {
        this.X = x;
    }

    public UXVariable getX() {
        return this.X;
    }

    public void setY(UXVariable y) {
        this.Y = y;
    }

    public UXVariable getY() {
        return this.Y;
    }

    public void setInstanceType(int instanceType) {
        this.instanceType = instanceType;
    }

    public int getInstanceType() {
        return this.instanceType;
    }

    public void setPointState(int pointState) {
        this.pointState = pointState;
    }

    public int getPointState() {
        return this.pointState;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Point)) {
            return false;
        }
        return this.getGeoObjectLabel().equals(((Point)obj).getGeoObjectLabel());
    }

    public boolean compare(Point pt) {
        return this.getGeoObjectLabel().compareTo(pt.getGeoObjectLabel()) < 0;
    }

    public void addDistance(String label, RatioOfCollinearSegments distance) {
        if (this.distances == null) {
            this.distances = new HashMap();
        }
        this.distances.put(label, distance);
    }

    private int renameCoordinate(short coordinateType, short newVarType, long newIndex, boolean writeToOutput) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        String messageForOutput = "";
        if (newVarType != 0 && newVarType != 1 || newVarType == 0 && newIndex < 0L || newVarType == 1 && newIndex <= 0L) {
            logger.error("Wrong variable for coordinate of point");
            if (writeToOutput) {
                try {
                    output.openItemWithDesc("Error: ");
                    output.closeItemWithDesc("Wrong variable for coordinate of point " + this.geoObjectLabel);
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                }
            }
            return -1;
        }
        messageForOutput = newVarType == 1 ? "dependent variable $x_{" + newIndex + "}$" : (newIndex == 0L ? "zero" : "independent variable $u_{" + newIndex + "}$");
        if (coordinateType == 2) {
            logger.info("Will try to rename X coordinate");
            if (writeToOutput) {
                try {
                    output.openItemWithDesc("Info: ");
                    output.closeItemWithDesc("Will try to rename X coordinate of point " + this.geoObjectLabel);
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
            }
            if (this.X.getVariableType() != 1) {
                logger.error("Attempt to rename independent variable");
                if (writeToOutput) {
                    try {
                        output.openItemWithDesc("Error: ");
                        output.closeItemWithDesc("Failed to rename X coordinate of point " + this.geoObjectLabel + " because it is independent variable");
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                    }
                }
                return -1;
            }
            boolean renameY = false;
            if (this.Y.getVariableType() == 1) {
                if (this.Y.getIndex() > this.X.getIndex()) {
                    logger.info("Will rename Y coordinate by variable of X coordinate");
                    if (writeToOutput) {
                        try {
                            output.openItemWithDesc("Info: ");
                            output.closeItemWithDesc("Y coordinate of point " + this.geoObjectLabel + " will be replaced by X coordinate");
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                    }
                    this.Y.setIndex(this.X.getIndex());
                } else if (this.Y.getIndex() == this.X.getIndex()) {
                    logger.info("Another coordinate of point will be renamed too");
                    if (writeToOutput) {
                        try {
                            output.openItemWithDesc("Info: ");
                            output.closeItemWithDesc("Y coordinate of point " + this.geoObjectLabel + " will be renamed too");
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                    }
                    renameY = true;
                }
            }
            this.X.setVariableType(newVarType);
            this.X.setIndex(newIndex);
            this.consProtocol.decrementXIndex();
            if (renameY) {
                this.Y.setVariableType(newVarType);
                this.Y.setIndex(newIndex);
            }
            this.pointState = 3;
            logger.info("X coordinate of this point has been renamed");
            if (writeToOutput) {
                try {
                    output.openItemWithDesc("Info: ");
                    StringBuilder sb = new StringBuilder();
                    sb.append("X coordinate of point ");
                    sb.append(this.geoObjectLabel);
                    sb.append(" renamed by ");
                    sb.append(messageForOutput);
                    output.closeItemWithDesc(sb.toString());
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
            }
            this.pointState = 3;
            return 3;
        }
        if (coordinateType == 3) {
            logger.info("Will try to rename Y coordinate");
            if (writeToOutput) {
                try {
                    output.openItemWithDesc("Info: ");
                    output.closeItemWithDesc("Will try to rename Y coordinate of point " + this.geoObjectLabel);
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
            }
            if (this.Y.getVariableType() != 1) {
                logger.error("Attempt to rename independent variable");
                if (writeToOutput) {
                    try {
                        output.openItemWithDesc("Error: ");
                        output.closeItemWithDesc("Failed to rename Y coordinate of point " + this.geoObjectLabel + " because it is independent variable");
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                    }
                }
                return -1;
            }
            boolean renameX = false;
            if (this.X.getVariableType() == 1) {
                if (this.X.getIndex() > this.Y.getIndex()) {
                    logger.info("Will rename X coordinate by variable of Y coordinate");
                    if (writeToOutput) {
                        try {
                            output.openItemWithDesc("Info: ");
                            output.closeItemWithDesc("X coordinate of point " + this.geoObjectLabel + " will be replaced by Y coordinate");
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                    }
                    this.X.setIndex(this.Y.getIndex());
                } else if (this.X.getIndex() == this.Y.getIndex()) {
                    logger.info("Another coordinate of point will be renamed too");
                    if (writeToOutput) {
                        try {
                            output.openItemWithDesc("Info: ");
                            output.closeItemWithDesc("X coordinate of point " + this.geoObjectLabel + " will be renamed too");
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                    }
                    renameX = true;
                }
            }
            this.Y.setVariableType(newVarType);
            this.Y.setIndex(newIndex);
            this.consProtocol.decrementXIndex();
            if (renameX) {
                this.X.setVariableType(newVarType);
                this.X.setIndex(newIndex);
            }
            logger.info("Y coordinate of this point has been renamed");
            if (writeToOutput) {
                try {
                    output.openItemWithDesc("Info: ");
                    StringBuilder sb = new StringBuilder();
                    sb.append("Y coordinate of point ");
                    sb.append(this.geoObjectLabel);
                    sb.append(" renamed by ");
                    sb.append(messageForOutput);
                    output.closeItemWithDesc(sb.toString());
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
            }
            this.pointState = 3;
            return 3;
        }
        logger.error("Wrong type of coordinate to rename");
        if (writeToOutput) {
            try {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Attempt to rename unknown coordinate of point " + this.geoObjectLabel);
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
            }
        }
        return -1;
    }

    private int addPolynomialToSystem(XPolynomial xPoly, boolean writeToOutput) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        logger.info("Adding polynomial to the system");
        if (writeToOutput) {
            try {
                output.openItemWithDesc("Info: ");
                output.writePlainText("Polynomial ");
                output.writePolynomial(xPoly);
                output.closeItemWithDesc(" added to system of polynomials that represents the constructions");
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
        }
        this.consProtocol.getAlgebraicGeoTheorem().getHypotheses().addXPoly(xPoly);
        logger.debug(xPoly.printToLaTeX());
        return 2;
    }

    public final int processConstructionPolynomial(XPolynomial xPoly, boolean writeToOutput) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        logger.debug("Starting processing of polynomial...");
        if (writeToOutput) {
            try {
                output.writePlainText("Processing of polynomial ");
                output.writePolynomial(xPoly);
                output.openEnum("description");
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
        }
        int retCode = this.processConstructionPolynomialLogic(xPoly, writeToOutput);
        logger.debug("Finished processing of polynomial");
        if (writeToOutput) {
            try {
                output.closeEnum("description");
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
        }
        return retCode;
    }

    private int processConstructionPolynomialLogic(XPolynomial xPoly, boolean writeToOutput) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        if (this.X.getVariableType() == 0 && this.Y.getVariableType() == 0) {
            logger.error("Attempt to assign a condition to free point");
            if (writeToOutput) {
                try {
                    output.openItemWithDesc("Error: ");
                    output.closeItemWithDesc("Attempt to assign a condition to free point " + this.geoObjectLabel);
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
            }
            return 0;
        }
        ArrayList<Term> terms = xPoly.getTermsAsDescList();
        boolean found = false;
        for (Term t : terms) {
            if ((this.X.getVariableType() != 1 || t.getVectorIndexOfVarIndex(this.X.getIndex()) <= -1) && (this.Y.getVariableType() != 1 || t.getVectorIndexOfVarIndex(this.Y.getIndex()) <= -1)) continue;
            found = true;
            break;
        }
        if (!found) {
            StringBuilder sb;
            if (this.instanceType == 1 || this.instanceType == 2) {
                logger.warn("Bad polynomial for this point - will try again");
                if (writeToOutput) {
                    try {
                        output.openItemWithDesc("Warning: ");
                        output.writePlainText("Polynomial ");
                        output.writePolynomial(xPoly);
                        sb = new StringBuilder();
                        sb.append(" is bad for point ");
                        sb.append(this.geoObjectLabel);
                        sb.append(" since it doesn't contain its coordinates - will try to re-instantiate the point's coordinates");
                        output.closeItemWithDesc(sb.toString());
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                        return -1;
                    }
                }
                return 1;
            }
            logger.error("Bad polynomial for this point");
            if (writeToOutput) {
                try {
                    output.openItemWithDesc("Error: ");
                    output.writePlainText("Polynomial ");
                    output.writePolynomial(xPoly);
                    sb = new StringBuilder();
                    sb.append(" is bad for point ");
                    sb.append(this.geoObjectLabel);
                    sb.append(" since it doesn't contain its coordinates");
                    output.closeItemWithDesc(sb.toString());
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
            }
            return 0;
        }
        if (terms.size() == 1) {
            Term singleTerm = terms.get(0);
            int powersSize = singleTerm.getPowers().size();
            if (powersSize == 1) {
                long varIndex = singleTerm.getPowers().get(0).getIndex();
                if (this.X.getVariableType() == 1 && this.X.getIndex() == varIndex) {
                    return this.renameCoordinate((short)2, (short)0, 0L, writeToOutput);
                }
                if (this.Y.getVariableType() == 1 && this.Y.getIndex() == varIndex) {
                    return this.renameCoordinate((short)3, (short)0, 0L, writeToOutput);
                }
                logger.error("Bad polynomial obtained when expected correct one");
                if (writeToOutput) {
                    try {
                        output.openItemWithDesc("Error: ");
                        output.closeItemWithDesc("Unexpected error during transformation of point " + this.geoObjectLabel + " into algebraic form");
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                    }
                }
                return -1;
            }
            if (powersSize == 0) {
                logger.error("Bad polynomial obtained when expected correct one");
                if (writeToOutput) {
                    try {
                        output.openItemWithDesc("Error: ");
                        output.closeItemWithDesc("Unexpected error during transformation of point " + this.geoObjectLabel + " into algebraic form");
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                    }
                }
                return -1;
            }
            return this.addPolynomialToSystem(xPoly, writeToOutput);
        }
        if (terms.size() == 2) {
            XTerm firstTerm = (XTerm)terms.get(0);
            XTerm secondTerm = (XTerm)terms.get(1);
            if (firstTerm.getPowers().size() > 1 || secondTerm.getPowers().size() > 1) {
                return this.addPolynomialToSystem(xPoly, writeToOutput);
            }
            if (firstTerm.getPowers().size() == 0) {
                logger.error("Bad polynomial obtained when expected correct one");
                if (writeToOutput) {
                    try {
                        output.openItemWithDesc("Error: ");
                        output.closeItemWithDesc("Unexpected error during transformation of point " + this.geoObjectLabel + " into algebraic form");
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                    }
                }
                return -1;
            }
            long firstVarIndex = firstTerm.getPowers().get(0).getIndex();
            UFraction reducedUF = secondTerm.getUCoeff().clone().mul(firstTerm.getUCoeff().clone().invertFraction()).reduce().invertSign();
            if (secondTerm.getPowers().size() == 1) {
                long secondVarIndex = secondTerm.getPowers().get(0).getIndex();
                if (reducedUF.getNumerator().clone().subtractPolynomial(reducedUF.getDenominator()).getTerms().size() == 0) {
                    if (this.X.getVariableType() == 1 && this.X.getIndex() == firstVarIndex) {
                        return this.renameCoordinate((short)2, (short)1, secondVarIndex, writeToOutput);
                    }
                    if (this.Y.getVariableType() == 1 && this.Y.getIndex() == firstVarIndex) {
                        return this.renameCoordinate((short)3, (short)1, secondVarIndex, writeToOutput);
                    }
                    logger.error("Bad polynomial obtained when expected correct one");
                    if (writeToOutput) {
                        try {
                            output.openItemWithDesc("Error: ");
                            output.closeItemWithDesc("Unexpected error during transformation of point " + this.geoObjectLabel + " into algebraic form");
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                        }
                    }
                    return -1;
                }
                return this.addPolynomialToSystem(xPoly, writeToOutput);
            }
            boolean onFirst = true;
            Term gcdTerm = null;
            for (Term t : reducedUF.getNumerator().getTermsAsDescList()) {
                if (onFirst) {
                    gcdTerm = (UTerm)((UTerm)t).clone();
                    ((UTerm)gcdTerm).setCoeff(1.0);
                    onFirst = false;
                    continue;
                }
                gcdTerm.gcd(t);
            }
            if (gcdTerm == null) {
                gcdTerm = new UTerm(1.0);
            }
            long uIndex = -1L;
            for (Power p : gcdTerm.getPowers()) {
                UTerm divisorTerm = new UTerm(1.0);
                Power newPower = p.clone();
                newPower.setExponent(1);
                divisorTerm.addPower(newPower);
                UPolynomial reducedNumerator = (UPolynomial)reducedUF.getNumerator().clone();
                if (reducedNumerator.divideByTerm(divisorTerm) == null) {
                    logger.error("Error in division of UPolynomial by UTerm");
                    if (writeToOutput) {
                        try {
                            output.openItemWithDesc("Error: ");
                            output.closeItemWithDesc("Unexpected error during transformation of point " + this.geoObjectLabel + " into algebraic form");
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                        }
                    }
                    return -1;
                }
                if (reducedNumerator.subtractPolynomial(reducedUF.getDenominator()).getTerms().size() != 0) continue;
                uIndex = p.getIndex();
                break;
            }
            if (uIndex > 0L) {
                if (this.X.getVariableType() == 1 && this.X.getIndex() == firstVarIndex) {
                    return this.renameCoordinate((short)2, (short)0, uIndex, writeToOutput);
                }
                if (this.Y.getVariableType() == 1 && this.Y.getIndex() == firstVarIndex) {
                    return this.renameCoordinate((short)3, (short)0, uIndex, writeToOutput);
                }
                logger.error("Bad polynomial obtained when expected correct one");
                if (writeToOutput) {
                    try {
                        output.openItemWithDesc("Error: ");
                        output.closeItemWithDesc("Unexpected error during transformation of point " + this.geoObjectLabel + " into algebraic form");
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                    }
                }
                return -1;
            }
            return this.addPolynomialToSystem(xPoly, writeToOutput);
        }
        if (terms.size() > 2) {
            return this.addPolynomialToSystem(xPoly, writeToOutput);
        }
        logger.error("Unknown error in processing polynomial for point's condition");
        if (writeToOutput) {
            try {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Unknown error during transformation of point " + this.geoObjectLabel + " into algebraic form");
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
            }
        }
        return -1;
    }
}

