/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.ConicSection;
import com.ogprover.pp.tp.geoconstruction.GeneralConicSection;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromCircle;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromGeneralConic;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromSetOfPoints;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.pp.tp.geoconstruction.ShortcutConstruction;
import com.ogprover.pp.tp.geoconstruction.TangentLine;
import java.util.Vector;

public class Polar
extends ShortcutConstruction {
    public static final String VERSION_NUM = "1.00";
    private Point pole;
    private SetOfPoints baseSet;

    @Override
    public Point getPoint() {
        return null;
    }

    @Override
    public Line getLine() {
        return (Line)this.shortcutListOfConstructions.get(this.shortcutListOfConstructions.size() - 1);
    }

    @Override
    public Circle getCircle() {
        return null;
    }

    @Override
    public ConicSection getConic() {
        return null;
    }

    public void setPole(Point pole) {
        this.pole = pole;
    }

    public Point getPole() {
        return this.pole;
    }

    public void setBaseSet(SetOfPoints baseSet) {
        this.baseSet = baseSet;
    }

    public SetOfPoints getBaseSet() {
        return this.baseSet;
    }

    public Polar(String lineLabel, Point pole, SetOfPoints baseSet) {
        RandomPointFromSetOfPoints B1;
        RandomPointFromSetOfPoints A1;
        this.shortcutListOfConstructions = new Vector();
        if (baseSet instanceof Line) {
            OpenGeoProver.settings.getLogger().error("Attempt to create polar with respect to line but conic or circle are expected");
            return;
        }
        if (baseSet instanceof Circle) {
            A1 = new RandomPointFromCircle("polarA1" + Math.round(Math.random() * 1000.0), (Circle)baseSet);
            B1 = new RandomPointFromCircle("polarB1" + Math.round(Math.random() * 1000.0), (Circle)baseSet);
        } else if (baseSet instanceof GeneralConicSection) {
            A1 = new RandomPointFromGeneralConic("polarA1" + Math.round(Math.random() * 1000.0), (GeneralConicSection)baseSet);
            B1 = new RandomPointFromGeneralConic("polarB1" + Math.round(Math.random() * 1000.0), (GeneralConicSection)baseSet);
        } else {
            OpenGeoProver.settings.getLogger().error("Unknown set of points passed in for construction of polar");
            return;
        }
        this.shortcutListOfConstructions.add(A1);
        this.shortcutListOfConstructions.add(B1);
        LineThroughTwoPoints a = new LineThroughTwoPoints("polara" + Math.round(Math.random() * 1000.0), pole, A1);
        LineThroughTwoPoints b = new LineThroughTwoPoints("polarb" + Math.round(Math.random() * 1000.0), pole, B1);
        this.shortcutListOfConstructions.add(a);
        this.shortcutListOfConstructions.add(b);
        IntersectionPoint A2 = new IntersectionPoint("polarA2" + Math.round(Math.random() * 1000.0), baseSet, a);
        IntersectionPoint B2 = new IntersectionPoint("polarB2" + Math.round(Math.random() * 1000.0), baseSet, b);
        this.shortcutListOfConstructions.add(A2);
        this.shortcutListOfConstructions.add(B2);
        TangentLine a1 = new TangentLine("polara1" + Math.round(Math.random() * 1000.0), A1, baseSet);
        TangentLine a2 = new TangentLine("polara2" + Math.round(Math.random() * 1000.0), A2, baseSet);
        TangentLine b1 = new TangentLine("polarb1" + Math.round(Math.random() * 1000.0), B1, baseSet);
        TangentLine b2 = new TangentLine("polarb2" + Math.round(Math.random() * 1000.0), B2, baseSet);
        this.shortcutListOfConstructions.add(a1);
        this.shortcutListOfConstructions.add(a2);
        this.shortcutListOfConstructions.add(b1);
        this.shortcutListOfConstructions.add(b2);
        IntersectionPoint A = new IntersectionPoint("polarA" + Math.round(Math.random() * 1000.0), a1, a2);
        IntersectionPoint B = new IntersectionPoint("polarB" + Math.round(Math.random() * 1000.0), b1, b2);
        this.shortcutListOfConstructions.add(A);
        this.shortcutListOfConstructions.add(B);
        this.shortcutListOfConstructions.add(new LineThroughTwoPoints(lineLabel, A, B));
        this.pole = pole;
        this.baseSet = baseSet;
    }

    @Override
    public String getConstructionDesc() {
        return "Polar";
    }
}

