/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.ConicSection;
import com.ogprover.pp.tp.geoconstruction.GeneralConicSection;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromCircle;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromGeneralConic;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromLine;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromSetOfPoints;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.pp.tp.geoconstruction.ShortcutConstruction;
import com.ogprover.pp.tp.geoconstruction.TangentLine;
import java.util.Vector;

public class Pole
extends ShortcutConstruction {
    public static final String VERSION_NUM = "1.00";
    private Line polar;
    private SetOfPoints baseSet;

    @Override
    public Point getPoint() {
        return (Point)this.shortcutListOfConstructions.get(this.shortcutListOfConstructions.size() - 1);
    }

    @Override
    public Line getLine() {
        return null;
    }

    @Override
    public Circle getCircle() {
        return null;
    }

    @Override
    public ConicSection getConic() {
        return null;
    }

    public void setPolar(Line polar) {
        this.polar = polar;
    }

    public Line getPolar() {
        return this.polar;
    }

    public void setBaseSet(SetOfPoints baseSet) {
        this.baseSet = baseSet;
    }

    public SetOfPoints getBaseSet() {
        return this.baseSet;
    }

    public Pole(String pointLabel, Line polar, SetOfPoints baseSet) {
        RandomPointFromSetOfPoints D21;
        RandomPointFromSetOfPoints D11;
        RandomPointFromSetOfPoints C21;
        RandomPointFromSetOfPoints C11;
        this.shortcutListOfConstructions = new Vector();
        if (baseSet instanceof Line) {
            OpenGeoProver.settings.getLogger().error("Attempt to create pole with respect to line but conic or circle are expected");
            return;
        }
        RandomPointFromLine A = new RandomPointFromLine("poleA" + Math.round(Math.random() * 1000.0), polar);
        this.shortcutListOfConstructions.add(A);
        RandomPointFromLine B = new RandomPointFromLine("poleB" + Math.round(Math.random() * 1000.0), polar);
        this.shortcutListOfConstructions.add(B);
        if (baseSet instanceof Circle) {
            C11 = new RandomPointFromCircle("poleC11" + Math.round(Math.random() * 1000.0), (Circle)baseSet);
            C21 = new RandomPointFromCircle("poleC21" + Math.round(Math.random() * 1000.0), (Circle)baseSet);
            D11 = new RandomPointFromCircle("poleD11" + Math.round(Math.random() * 1000.0), (Circle)baseSet);
            D21 = new RandomPointFromCircle("poleD21" + Math.round(Math.random() * 1000.0), (Circle)baseSet);
        } else if (baseSet instanceof GeneralConicSection) {
            C11 = new RandomPointFromGeneralConic("poleC11" + Math.round(Math.random() * 1000.0), (GeneralConicSection)baseSet);
            C21 = new RandomPointFromGeneralConic("poleC21" + Math.round(Math.random() * 1000.0), (GeneralConicSection)baseSet);
            D11 = new RandomPointFromGeneralConic("poleD11" + Math.round(Math.random() * 1000.0), (GeneralConicSection)baseSet);
            D21 = new RandomPointFromGeneralConic("poleD21" + Math.round(Math.random() * 1000.0), (GeneralConicSection)baseSet);
        } else {
            OpenGeoProver.settings.getLogger().error("Unknown set of points passed in for construction of pole");
            return;
        }
        this.shortcutListOfConstructions.add(C11);
        this.shortcutListOfConstructions.add(C21);
        this.shortcutListOfConstructions.add(D11);
        this.shortcutListOfConstructions.add(D21);
        LineThroughTwoPoints a1 = new LineThroughTwoPoints("polea1" + Math.round(Math.random() * 1000.0), A, C11);
        LineThroughTwoPoints a2 = new LineThroughTwoPoints("polea2" + Math.round(Math.random() * 1000.0), A, C21);
        LineThroughTwoPoints b1 = new LineThroughTwoPoints("poleb1" + Math.round(Math.random() * 1000.0), B, D11);
        LineThroughTwoPoints b2 = new LineThroughTwoPoints("poleb2" + Math.round(Math.random() * 1000.0), B, D21);
        this.shortcutListOfConstructions.add(a1);
        this.shortcutListOfConstructions.add(a2);
        this.shortcutListOfConstructions.add(b1);
        this.shortcutListOfConstructions.add(b2);
        IntersectionPoint C12 = new IntersectionPoint("poleC12" + Math.round(Math.random() * 1000.0), baseSet, a1);
        IntersectionPoint C22 = new IntersectionPoint("poleC22" + Math.round(Math.random() * 1000.0), baseSet, a2);
        IntersectionPoint D12 = new IntersectionPoint("poleD12" + Math.round(Math.random() * 1000.0), baseSet, b1);
        IntersectionPoint D22 = new IntersectionPoint("poleD22" + Math.round(Math.random() * 1000.0), baseSet, b2);
        this.shortcutListOfConstructions.add(C12);
        this.shortcutListOfConstructions.add(C22);
        this.shortcutListOfConstructions.add(D12);
        this.shortcutListOfConstructions.add(D22);
        TangentLine c11 = new TangentLine("polec11" + Math.round(Math.random() * 1000.0), C11, baseSet);
        TangentLine c12 = new TangentLine("polec12" + Math.round(Math.random() * 1000.0), C12, baseSet);
        TangentLine c21 = new TangentLine("polec21" + Math.round(Math.random() * 1000.0), C21, baseSet);
        TangentLine c22 = new TangentLine("polec22" + Math.round(Math.random() * 1000.0), C22, baseSet);
        TangentLine d11 = new TangentLine("poled11" + Math.round(Math.random() * 1000.0), D11, baseSet);
        TangentLine d12 = new TangentLine("poled12" + Math.round(Math.random() * 1000.0), D12, baseSet);
        TangentLine d21 = new TangentLine("poled21" + Math.round(Math.random() * 1000.0), D21, baseSet);
        TangentLine d22 = new TangentLine("poled22" + Math.round(Math.random() * 1000.0), D22, baseSet);
        this.shortcutListOfConstructions.add(c11);
        this.shortcutListOfConstructions.add(c12);
        this.shortcutListOfConstructions.add(c21);
        this.shortcutListOfConstructions.add(c22);
        this.shortcutListOfConstructions.add(d11);
        this.shortcutListOfConstructions.add(d12);
        this.shortcutListOfConstructions.add(d21);
        this.shortcutListOfConstructions.add(d22);
        IntersectionPoint T1 = new IntersectionPoint("poleT1" + Math.round(Math.random() * 1000.0), c11, c12);
        IntersectionPoint T2 = new IntersectionPoint("poleT2" + Math.round(Math.random() * 1000.0), c21, c22);
        IntersectionPoint U1 = new IntersectionPoint("poleU1" + Math.round(Math.random() * 1000.0), d11, d12);
        IntersectionPoint U2 = new IntersectionPoint("poleU2" + Math.round(Math.random() * 1000.0), d21, d22);
        this.shortcutListOfConstructions.add(T1);
        this.shortcutListOfConstructions.add(T2);
        this.shortcutListOfConstructions.add(U1);
        this.shortcutListOfConstructions.add(U2);
        LineThroughTwoPoints t = new LineThroughTwoPoints("polet" + Math.round(Math.random() * 1000.0), T1, T2);
        LineThroughTwoPoints u = new LineThroughTwoPoints("poleu" + Math.round(Math.random() * 1000.0), U1, U2);
        this.shortcutListOfConstructions.add(t);
        this.shortcutListOfConstructions.add(u);
        this.shortcutListOfConstructions.add(new IntersectionPoint(pointLabel, t, u));
        this.polar = polar;
        this.baseSet = baseSet;
    }

    @Override
    public String getConstructionDesc() {
        return "Pole";
    }
}

