/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndRadius;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class RadicalAxis
extends Line {
    public static final String VERSION_NUM = "1.00";
    private static final String M0Label = "0";
    private static final String O1Label = "O1";
    private static final String A1Label = "A1";
    private static final String B1Label = "B1";
    private static final String O2Label = "O2";
    private static final String A2Label = "A2";
    private static final String B2Label = "B2";
    private Circle firstCircle;
    private Circle secondCircle;
    private static SymbolicPolynomial conditionForRadicalAxis = null;

    @Override
    public int getConstructionType() {
        return 46;
    }

    public void setFirstCircle(Circle firstCircle) {
        this.firstCircle = firstCircle;
    }

    public Circle getFirstCircle() {
        return this.firstCircle;
    }

    public void setSecondCircle(Circle secondCircle) {
        this.secondCircle = secondCircle;
    }

    public Circle getSecondCircle() {
        return this.secondCircle;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForRadicalAxis;
    }

    public RadicalAxis(String lineLabel, Circle firstCircle, Circle secondCircle) {
        this.geoObjectLabel = lineLabel;
        this.firstCircle = firstCircle;
        this.secondCircle = secondCircle;
        this.points = new Vector();
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            if (this.firstCircle == null || this.secondCircle == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct radical axis " + this.getGeoObjectLabel() + " because some of circles is not constructed");
                return false;
            }
            int index1 = this.firstCircle.getIndex();
            int index2 = this.secondCircle.getIndex();
            if (index1 < 0 || index2 < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct radical axis " + this.getGeoObjectLabel() + " because some of circles is not added to theorem protocol");
                return false;
            }
            if (index1 >= this.index || index2 >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct radical axis " + this.getGeoObjectLabel() + " because some of circles is not yet constructed");
                return false;
            }
            Point c1 = this.firstCircle.getCenter();
            Point c2 = this.secondCircle.getCenter();
            if (c1 == null || c2 == null || c1.getIndex() >= this.index || c2.getIndex() >= this.index || c1.getIndex() < 0 || c2.getIndex() < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct radical axis " + this.getGeoObjectLabel() + " because some of circles doesn't have constructed center");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        super.findBestPointsForInstantation(manager);
        if (manager.isErrorFlag()) {
            logger.error("Failed in findBestPointsForInstantation() method from superclass");
            return -1;
        }
        if (manager.getPoint().getPointState() == 3) {
            return 0;
        }
        manager.getPoint().setPointState(4);
        manager.setCondition(this.getCondition());
        Point P = manager.getPoint();
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(O1Label, this.firstCircle.getCenter());
        pointsMap.put(O2Label, this.secondCircle.getCenter());
        if (this.firstCircle instanceof CircleWithCenterAndRadius) {
            pointsMap.put(A1Label, ((CircleWithCenterAndRadius)this.firstCircle).getRadius().getFirstEndPoint());
            pointsMap.put(B1Label, ((CircleWithCenterAndRadius)this.firstCircle).getRadius().getSecondEndPoint());
            if (this.secondCircle instanceof CircleWithCenterAndRadius) {
                pointsMap.put(A2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getFirstEndPoint());
                pointsMap.put(B2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getSecondEndPoint());
                manager.processPointsAndCondition(pointsMap);
                if (manager.isErrorFlag()) {
                    logger.error("findBestPointsForInstantation() method failed in processing condition for radical axis");
                    return -1;
                }
                if (manager.getPoint().getPointState() == 3) {
                    return 0;
                }
            }
            P.setPointState(4);
            pointsMap.put(A2Label, this.secondCircle.getCenter());
            int jB = this.secondCircle.points.size();
            for (int iB = 0; iB < jB; ++iB) {
                Point pointB = this.secondCircle.points.get(iB);
                if (pointB.getIndex() >= P.getIndex()) continue;
                pointsMap.put(B2Label, pointB);
                manager.processPointsAndCondition(pointsMap);
                if (manager.isErrorFlag()) {
                    logger.error("findBestPointsForInstantation() method failed in processing condition for radical axis");
                    return -1;
                }
                if (manager.getPoint().getPointState() != 3) continue;
                return 0;
            }
        }
        P.setPointState(4);
        pointsMap.put(A1Label, this.firstCircle.getCenter());
        int jB1 = this.firstCircle.points.size();
        for (int iB1 = 0; iB1 < jB1; ++iB1) {
            Point pointB1 = this.firstCircle.points.get(iB1);
            if (pointB1.getIndex() >= P.getIndex()) continue;
            pointsMap.put(B1Label, pointB1);
            if (this.secondCircle instanceof CircleWithCenterAndRadius) {
                pointsMap.put(A2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getFirstEndPoint());
                pointsMap.put(B2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getSecondEndPoint());
                manager.processPointsAndCondition(pointsMap);
                if (manager.isErrorFlag()) {
                    logger.error("findBestPointsForInstantation() method failed in processing condition for radical axis");
                    return -1;
                }
                if (manager.getPoint().getPointState() == 3) {
                    return 0;
                }
            }
            P.setPointState(4);
            pointsMap.put(A2Label, this.secondCircle.getCenter());
            int jB2 = this.secondCircle.points.size();
            for (int iB2 = 0; iB2 < jB2; ++iB2) {
                Point pointB2 = this.secondCircle.points.get(iB2);
                if (pointB2.getIndex() >= P.getIndex()) continue;
                pointsMap.put(B2Label, pointB2);
                manager.processPointsAndCondition(pointsMap);
                if (manager.isErrorFlag()) {
                    logger.error("findBestPointsForInstantation() method failed in processing condition for radical axis");
                    return -1;
                }
                if (manager.getPoint().getPointState() != 3) continue;
                return 0;
            }
        }
        return 0;
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(O1Label, this.firstCircle.getCenter());
        if (this.firstCircle instanceof CircleWithCenterAndRadius) {
            pointsMap.put(A1Label, ((CircleWithCenterAndRadius)this.firstCircle).getRadius().getFirstEndPoint());
            pointsMap.put(B1Label, ((CircleWithCenterAndRadius)this.firstCircle).getRadius().getSecondEndPoint());
        } else {
            pointsMap.put(A1Label, this.firstCircle.getCenter());
            pointsMap.put(B1Label, this.firstCircle.getPoints().get(0));
        }
        pointsMap.put(O2Label, this.secondCircle.getCenter());
        if (this.secondCircle instanceof CircleWithCenterAndRadius) {
            pointsMap.put(A2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getFirstEndPoint());
            pointsMap.put(B2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getSecondEndPoint());
        } else {
            pointsMap.put(A2Label, this.secondCircle.getCenter());
            pointsMap.put(B2Label, this.secondCircle.getPoints().get(0));
        }
        return this.instantiateCondition(pointsMap);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = super.getAllPossibleConditionsWithMappings();
        ArrayList allMappings = new ArrayList();
        HashMap<String, Point> pointsMap = null;
        if (this.firstCircle instanceof CircleWithCenterAndRadius) {
            if (this.secondCircle instanceof CircleWithCenterAndRadius) {
                pointsMap = new HashMap<String, Point>();
                pointsMap.put(A1Label, ((CircleWithCenterAndRadius)this.firstCircle).getRadius().getFirstEndPoint());
                pointsMap.put(B1Label, ((CircleWithCenterAndRadius)this.firstCircle).getRadius().getSecondEndPoint());
                pointsMap.put(A2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getFirstEndPoint());
                pointsMap.put(B2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getSecondEndPoint());
                pointsMap.put(O1Label, this.firstCircle.getCenter());
                pointsMap.put(O2Label, this.secondCircle.getCenter());
                allMappings.add(pointsMap);
            }
            for (Point pointB2 : this.secondCircle.getPoints()) {
                pointsMap = new HashMap();
                pointsMap.put(A1Label, ((CircleWithCenterAndRadius)this.firstCircle).getRadius().getFirstEndPoint());
                pointsMap.put(B1Label, ((CircleWithCenterAndRadius)this.firstCircle).getRadius().getSecondEndPoint());
                pointsMap.put(A2Label, this.secondCircle.getCenter());
                pointsMap.put(B2Label, pointB2);
                pointsMap.put(O1Label, this.firstCircle.getCenter());
                pointsMap.put(O2Label, this.secondCircle.getCenter());
                allMappings.add(pointsMap);
            }
        }
        for (Point pointB1 : this.firstCircle.getPoints()) {
            if (this.secondCircle instanceof CircleWithCenterAndRadius) {
                pointsMap = new HashMap();
                pointsMap.put(A1Label, this.firstCircle.getCenter());
                pointsMap.put(B1Label, pointB1);
                pointsMap.put(A2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getFirstEndPoint());
                pointsMap.put(B2Label, ((CircleWithCenterAndRadius)this.secondCircle).getRadius().getSecondEndPoint());
                pointsMap.put(O1Label, this.firstCircle.getCenter());
                pointsMap.put(O2Label, this.secondCircle.getCenter());
                allMappings.add(pointsMap);
            }
            for (Point pointB2 : this.secondCircle.getPoints()) {
                pointsMap = new HashMap();
                pointsMap.put(A1Label, this.firstCircle.getCenter());
                pointsMap.put(B1Label, pointB1);
                pointsMap.put(A2Label, this.secondCircle.getCenter());
                pointsMap.put(B2Label, pointB2);
                pointsMap.put(O1Label, this.firstCircle.getCenter());
                pointsMap.put(O2Label, this.secondCircle.getCenter());
                allMappings.add(pointsMap);
            }
        }
        retMap.put((SymbolicPolynomial)this.getCondition().clone(), allMappings);
        return retMap;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Radical axis ");
        sb.append(this.geoObjectLabel);
        sb.append(" of circles ");
        sb.append(this.firstCircle.getGeoObjectLabel());
        sb.append(" and ");
        sb.append(this.secondCircle.getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.firstCircle.getGeoObjectLabel(), this.secondCircle.getGeoObjectLabel()};
        return inputLabels;
    }

    static {
        if (conditionForRadicalAxis == null) {
            conditionForRadicalAxis = new SymbolicPolynomial();
            SymbolicPolynomial tempSymbPoly = (SymbolicPolynomial)Segment.getConditionForSquareOfDistance().clone();
            Segment.substitutePointLabelsForSquareOfDistance(tempSymbPoly, M0Label, O1Label);
            conditionForRadicalAxis.addPolynomial(tempSymbPoly);
            tempSymbPoly = (SymbolicPolynomial)Segment.getConditionForSquareOfDistance().clone();
            Segment.substitutePointLabelsForSquareOfDistance(tempSymbPoly, M0Label, O2Label);
            conditionForRadicalAxis.subtractPolynomial(tempSymbPoly);
            tempSymbPoly = (SymbolicPolynomial)Segment.getConditionForSquareOfDistance().clone();
            Segment.substitutePointLabelsForSquareOfDistance(tempSymbPoly, A1Label, B1Label);
            conditionForRadicalAxis.subtractPolynomial(tempSymbPoly);
            tempSymbPoly = (SymbolicPolynomial)Segment.getConditionForSquareOfDistance().clone();
            Segment.substitutePointLabelsForSquareOfDistance(tempSymbPoly, A2Label, B2Label);
            conditionForRadicalAxis.addPolynomial(tempSymbPoly);
        }
    }
}

