/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromSetOfPoints;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;

public class RandomPointFromLine
extends RandomPointFromSetOfPoints {
    public static final String VERSION_NUM = "1.00";

    @Override
    public int getConstructionType() {
        return 30;
    }

    public RandomPointFromLine(String pointLabel, Line line) {
        this.geoObjectLabel = pointLabel;
        this.baseSetOfPoints = line;
        if (this.baseSetOfPoints != null) {
            this.baseSetOfPoints.addPointToSet(this);
        }
    }

    @Override
    public Point clone() {
        RandomPointFromLine p = new RandomPointFromLine(this.geoObjectLabel, null);
        p.setBaseSetOfPoints(this.baseSetOfPoints);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        Line baseLine = (Line)this.baseSetOfPoints;
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            if (baseLine == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Random point " + this.getGeoObjectLabel() + " can't be constructed since its base line is not constructed");
                return false;
            }
            if (baseLine.getIndex() < 0 || baseLine.getIndex() >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Random point " + this.getGeoObjectLabel() + " can't be constructed since its base line is not yet constructed or not added to theorem protocol");
                return false;
            }
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
        return true;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Random point ");
        sb.append(this.geoObjectLabel);
        sb.append(" from line ");
        sb.append(((GeoConstruction)((Object)this.baseSetOfPoints)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        return null;
    }
}

