/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromSetOfPoints;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;

public abstract class RandomPointFromParametricSet
extends RandomPointFromSetOfPoints {
    public static final String VERSION_NUM = "1.00";

    @Override
    public int transformToAlgebraicForm() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        try {
            output.openSubSection("Transformation of point " + this.geoObjectLabel + ": ", true);
            output.openEnum("itemize");
            this.consProtocol.instantiatePoint(this, 1);
            output.openItem();
            output.writePointCoordinatesAssignment(this);
            output.closeItem();
            if (this.getX().getVariableType() == 0 && this.getX().getIndex() == 0L && this.getY().getVariableType() == 0 && this.getY().getIndex() == 0L) {
                output.closeEnum("itemize");
                output.closeSubSection();
                return 0;
            }
            PointSetRelationshipManager manager = new PointSetRelationshipManager(this.baseSetOfPoints, this);
            XPolynomial condition = manager.retrieveInstantiatedCondition();
            output.openItem();
            output.writePlainText("Polynomial that point " + this.geoObjectLabel + " has to satisfy is:");
            output.writePolynomial(condition);
            output.closeItem();
            if (condition == null) {
                logger.error("Failed to instantiate the condition for this point");
                output.closeEnum("itemize");
                output.closeSubSection();
                return -1;
            }
            output.openItem();
            int retCode = this.processConstructionPolynomial(condition, true);
            output.closeItem();
            switch (retCode) {
                case -1: 
                case 0: 
                case 1: {
                    logger.error("Error or bad polynomial instantiated when transforming to algebraic form");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
                case 3: {
                    logger.info("Renamed coordinates of point " + this.getGeoObjectLabel());
                    output.openItem();
                    output.writePlainText("Point " + this.geoObjectLabel + " has been renamed. ");
                    output.writePointCoordinatesAssignment(this);
                    output.closeItem();
                    break;
                }
                case 2: {
                    logger.info("New polynomial condition added to system of hypotheses");
                    output.openItem();
                    output.writePlainText("New polynomial added to system of hypotheses");
                    output.closeItem();
                    break;
                }
                default: {
                    logger.error("Unknown return result from processing of condition");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
            }
            output.closeEnum("itemize");
            output.closeSubSection();
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }
}

