/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.GeneralConicSection;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromCircle;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromGeneralConic;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromLine;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;

public abstract class RandomPointFromSetOfPoints
extends Point {
    public static final String VERSION_NUM = "1.00";
    protected SetOfPoints baseSetOfPoints;

    public void setBaseSetOfPoints(SetOfPoints baseSetOfPoints) {
        this.baseSetOfPoints = baseSetOfPoints;
    }

    public SetOfPoints getBaseSetOfPoints() {
        return this.baseSetOfPoints;
    }

    @Override
    public int transformToAlgebraicForm() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        try {
            output.openSubSection("Transformation of point " + this.geoObjectLabel + ": ", true);
            output.openEnum("itemize");
            this.consProtocol.instantiatePoint(this, 1);
            output.openItem();
            output.writePointCoordinatesAssignment(this);
            output.closeItem();
            PointSetRelationshipManager manager = new PointSetRelationshipManager(this.baseSetOfPoints, this);
            XPolynomial condition = manager.retrieveInstantiatedCondition();
            output.openItem();
            output.writePlainText("Polynomial that point " + this.geoObjectLabel + " has to satisfy is:");
            output.writePolynomial(condition);
            output.closeItem();
            if (condition == null) {
                logger.error("Failed to instantiate the condition for this point");
                output.closeEnum("itemize");
                output.closeSubSection();
                return -1;
            }
            output.openItem();
            int retCode = this.processConstructionPolynomial(condition, true);
            output.closeItem();
            switch (retCode) {
                case -1: 
                case 0: 
                case 1: {
                    logger.error("Error or bad polynomial instantiated when transforming to algebraic form");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
                case 3: {
                    logger.info("Renamed coordinates of point " + this.getGeoObjectLabel());
                    output.openItem();
                    output.writePlainText("Point " + this.geoObjectLabel + " has been renamed. ");
                    output.writePointCoordinatesAssignment(this);
                    output.closeItem();
                    break;
                }
                case 2: {
                    logger.info("New polynomial condition added to system of hypotheses");
                    output.openItem();
                    output.writePlainText("New polynomial added to system of hypotheses");
                    output.closeItem();
                    break;
                }
                default: {
                    logger.error("Unknown return result from processing of condition");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
            }
            output.closeEnum("itemize");
            output.closeSubSection();
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }

    public static Point createRandomPoint(String ptLabel, SetOfPoints ptSet) {
        if (ptSet instanceof Line) {
            return new RandomPointFromLine(ptLabel, (Line)ptSet);
        }
        if (ptSet instanceof Circle) {
            return new RandomPointFromCircle(ptLabel, (Circle)ptSet);
        }
        if (ptSet instanceof GeneralConicSection) {
            return new RandomPointFromGeneralConic(ptLabel, (GeneralConicSection)ptSet);
        }
        return null;
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{((GeoConstruction)((Object)this.baseSetOfPoints)).getGeoObjectLabel()};
        return inputLabels;
    }
}

