/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SelfConditionalPoint;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RotatedPoint
extends SelfConditionalPoint {
    public static final String VERSION_NUM = "1.00";
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String SLabel = "S";
    private Point originalPoint = null;
    private Point centerOfRotation = null;
    private double radAngleMeasure = 0.0;
    private double degAngleMeasure = 0.0;

    public void setOriginalPoint(Point originalPoint) {
        this.originalPoint = originalPoint;
    }

    public Point getOriginalPoint() {
        return this.originalPoint;
    }

    public void setCenterOfRotation(Point centerOfRotation) {
        this.centerOfRotation = centerOfRotation;
    }

    public Point getCenterOfRotation() {
        return this.centerOfRotation;
    }

    public void setRadAngleMeasure(double radAngleMeasure) {
        this.radAngleMeasure = radAngleMeasure;
    }

    public double getRadAngleMeasure() {
        return this.radAngleMeasure;
    }

    public void setDegAngleMeasure(double degAngleMeasure) {
        this.degAngleMeasure = degAngleMeasure;
    }

    public double getDegAngleMeasure() {
        return this.degAngleMeasure;
    }

    @Override
    public int getConstructionType() {
        return 6;
    }

    @Override
    public SymbolicPolynomial getXCondition() {
        SymbolicPolynomial xConditionForRotatedPoint = new SymbolicPolynomial();
        SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
        SymbolicVariable xA = new SymbolicVariable(2, ALabel);
        SymbolicVariable yA = new SymbolicVariable(3, ALabel);
        SymbolicVariable xS = new SymbolicVariable(2, SLabel);
        SymbolicVariable yS = new SymbolicVariable(3, SLabel);
        SymbolicPolynomial m0Part = new SymbolicPolynomial();
        SymbolicPolynomial xPart = new SymbolicPolynomial();
        SymbolicPolynomial yPart = new SymbolicPolynomial();
        SymbolicPolynomial zPart = new SymbolicPolynomial();
        SymbolicTerm tempTerm = null;
        tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(x0, 1));
        m0Part.addTerm(tempTerm);
        tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(xA, 1));
        xPart.addTerm(tempTerm);
        tempTerm = new SymbolicTerm(-1.0);
        tempTerm.addPower(new Power(xS, 1));
        xPart.addTerm(tempTerm);
        xPart.multiplyByRealConstant(Math.cos(this.radAngleMeasure));
        tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(yA, 1));
        yPart.addTerm(tempTerm);
        tempTerm = new SymbolicTerm(-1.0);
        tempTerm.addPower(new Power(yS, 1));
        yPart.addTerm(tempTerm);
        yPart.multiplyByRealConstant(Math.sin(this.radAngleMeasure));
        tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(xS, 1));
        zPart.addTerm(tempTerm);
        xConditionForRotatedPoint.addPolynomial(m0Part);
        xConditionForRotatedPoint.subtractPolynomial(xPart);
        xConditionForRotatedPoint.addPolynomial(yPart);
        xConditionForRotatedPoint.subtractPolynomial(zPart);
        return xConditionForRotatedPoint;
    }

    @Override
    public SymbolicPolynomial getYCondition() {
        SymbolicPolynomial yConditionForRotatedPoint = new SymbolicPolynomial();
        SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
        SymbolicVariable xA = new SymbolicVariable(2, ALabel);
        SymbolicVariable yA = new SymbolicVariable(3, ALabel);
        SymbolicVariable xS = new SymbolicVariable(2, SLabel);
        SymbolicVariable yS = new SymbolicVariable(3, SLabel);
        SymbolicPolynomial m0Part = new SymbolicPolynomial();
        SymbolicPolynomial xPart = new SymbolicPolynomial();
        SymbolicPolynomial yPart = new SymbolicPolynomial();
        SymbolicPolynomial zPart = new SymbolicPolynomial();
        SymbolicTerm tempTerm = null;
        tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(y0, 1));
        m0Part.addTerm(tempTerm);
        tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(xA, 1));
        xPart.addTerm(tempTerm);
        tempTerm = new SymbolicTerm(-1.0);
        tempTerm.addPower(new Power(xS, 1));
        xPart.addTerm(tempTerm);
        xPart.multiplyByRealConstant(Math.sin(this.radAngleMeasure));
        tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(yA, 1));
        yPart.addTerm(tempTerm);
        tempTerm = new SymbolicTerm(-1.0);
        tempTerm.addPower(new Power(yS, 1));
        yPart.addTerm(tempTerm);
        yPart.multiplyByRealConstant(Math.cos(this.radAngleMeasure));
        tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(yS, 1));
        zPart.addTerm(tempTerm);
        yConditionForRotatedPoint.addPolynomial(m0Part);
        yConditionForRotatedPoint.subtractPolynomial(xPart);
        yConditionForRotatedPoint.subtractPolynomial(yPart);
        yConditionForRotatedPoint.subtractPolynomial(zPart);
        return yConditionForRotatedPoint;
    }

    public RotatedPoint(String pointLabel, Point originalPoint, Point center, double degAngMeasure) {
        this.geoObjectLabel = pointLabel;
        this.originalPoint = originalPoint;
        this.centerOfRotation = center;
        this.degAngleMeasure = degAngMeasure;
        this.radAngleMeasure = this.degAngleMeasure * Math.PI / 180.0;
    }

    @Override
    public Point clone() {
        RotatedPoint p = new RotatedPoint(this.geoObjectLabel, this.originalPoint, this.centerOfRotation, this.degAngleMeasure);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            if (this.originalPoint == null || this.centerOfRotation == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Rotated point " + this.getGeoObjectLabel() + " can't be constructed since original point or center of rotation are not constructed");
                return false;
            }
            int indexOP = this.originalPoint.getIndex();
            int indexC = this.centerOfRotation.getIndex();
            if (indexOP < 0 || indexC < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Rotated point " + this.getGeoObjectLabel() + " can't be constructed since original point or center of rotation are not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexOP && this.index > indexC;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Rotated point " + this.getGeoObjectLabel() + " can't be constructed since original point or center of rotation are not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rotated point ");
        sb.append(this.geoObjectLabel);
        sb.append(" of point ");
        sb.append(this.originalPoint.getGeoObjectLabel());
        sb.append(" around point ");
        sb.append(this.centerOfRotation.getGeoObjectLabel());
        sb.append(" for angle of ");
        sb.append(this.degAngleMeasure);
        sb.append(" degrees");
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.originalPoint.getGeoObjectLabel(), this.centerOfRotation.getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Map<String, Point> getPointsForInstantiation() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, this);
        pointsMap.put(ALabel, this.originalPoint);
        pointsMap.put(SLabel, this.centerOfRotation);
        return pointsMap;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        OpenGeoProver.settings.getLogger().error("This method should not be called on this class.");
        return null;
    }
}

