/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.XPolySystem;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.Map;

public abstract class SelfConditionalPoint
extends Point {
    public static final String VERSION_NUM = "1.00";

    public abstract SymbolicPolynomial getXCondition();

    public abstract SymbolicPolynomial getYCondition();

    public abstract Map<String, Point> getPointsForInstantiation();

    public XPolynomial instantiateXCondition(Map<String, Point> pointsMap) {
        return OGPTP.instantiateCondition(this.getXCondition(), pointsMap);
    }

    public XPolynomial instantiateYCondition(Map<String, Point> pointsMap) {
        return OGPTP.instantiateCondition(this.getYCondition(), pointsMap);
    }

    @Override
    public int transformToAlgebraicForm() {
        return this.transformToAlgebraicForm(this.getPointsForInstantiation());
    }

    public int transformToAlgebraicForm(Map<String, Point> pointsMap) {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        try {
            output.openSubSection("Transformation of point " + this.geoObjectLabel + ": ", true);
            output.openEnum("itemize");
            this.consProtocol.instantiatePoint(this, 3);
            output.openItem();
            output.writePointCoordinatesAssignment(this);
            output.closeItem();
            XPolynomial xCondInstance = this.instantiateXCondition(pointsMap).reduceByUTermDivision();
            if (xCondInstance == null) {
                output.closeEnum("itemize");
                output.openEnum("description");
                output.openItemWithDesc("Error:");
                output.closeItemWithDesc("Failed to instantiate the condition");
                output.closeEnum("description");
                output.closeSubSection();
                return -1;
            }
            output.openItem();
            output.writePlainText("Instantiating condition for X-coordinate of this point");
            output.closeItem();
            output.openItem();
            int xRetCode = this.processConstructionPolynomial(xCondInstance, true);
            output.closeItem();
            switch (xRetCode) {
                case -1: 
                case 0: {
                    logger.error("Error or bad polynomial obtained during processing");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
                case 1: {
                    logger.error("Bad polynomial obtained during processing");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
                case 3: {
                    logger.info("Renamed coordinates of point " + this.geoObjectLabel);
                    output.openItem();
                    output.writePlainText("Point " + this.geoObjectLabel + " has been renamed. ");
                    output.writePointCoordinatesAssignment(this);
                    output.closeItem();
                    break;
                }
                case 2: {
                    output.openItem();
                    output.writePlainText("Instantiated condition ");
                    output.writePolynomial(xCondInstance);
                    output.writePlainText(" is added to polynomial system\n");
                    output.closeItem();
                    break;
                }
                default: {
                    logger.error("Unknown error during processing");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
            }
            output.openItem();
            output.writePlainText("Instantiating condition for Y-coordinate of this point");
            output.closeItem();
            XPolynomial yCondInstance = this.instantiateYCondition(pointsMap).reduceByUTermDivision();
            output.openItem();
            int yRetCode = this.processConstructionPolynomial(yCondInstance, true);
            output.closeItem();
            switch (yRetCode) {
                case -1: 
                case 0: {
                    logger.error("Error or bad polynomial obtained during processing");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
                case 1: {
                    logger.error("Bad polynomial obtained during processing");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
                case 3: {
                    logger.info("Renamed coordinates of point " + this.geoObjectLabel);
                    output.openItem();
                    output.writePlainText("Point " + this.geoObjectLabel + " has been renamed. ");
                    output.writePointCoordinatesAssignment(this);
                    output.closeItem();
                    break;
                }
                case 2: {
                    output.openItem();
                    output.writePlainText("Instantiated condition ");
                    output.writePolynomial(yCondInstance);
                    output.writePlainText(" is added to polynomial system\n");
                    output.closeItem();
                    break;
                }
                default: {
                    logger.error("Unknown error during processing");
                    output.closeEnum("itemize");
                    output.openEnum("description");
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc("Failed to process the condition");
                    output.closeEnum("description");
                    output.closeSubSection();
                    return -1;
                }
            }
            if (yRetCode == 3 && xRetCode == 2) {
                XPolySystem system = this.consProtocol.getAlgebraicGeoTheorem().getHypotheses();
                system.removePoly(system.getPolynomials().size() - 1);
                output.openItem();
                output.writePlainText("Repeating instantiation of condition for X-coordinate of this point, after it has been renamed");
                output.closeItem();
                xCondInstance = this.instantiateXCondition(pointsMap).reduceByUTermDivision();
                output.openItem();
                xRetCode = this.processConstructionPolynomial(xCondInstance, true);
                output.closeItem();
                switch (xRetCode) {
                    case -1: 
                    case 0: {
                        logger.error("Error or bad polynomial obtained during processing");
                        output.closeEnum("itemize");
                        output.openEnum("description");
                        output.openItemWithDesc("Error:");
                        output.closeItemWithDesc("Failed to process the condition");
                        output.closeEnum("description");
                        output.closeSubSection();
                        return -1;
                    }
                    case 1: {
                        logger.error("Bad polynomial obtained during processing");
                        output.closeEnum("itemize");
                        output.openEnum("description");
                        output.openItemWithDesc("Error:");
                        output.closeItemWithDesc("Failed to process the condition");
                        output.closeEnum("description");
                        output.closeSubSection();
                        return -1;
                    }
                    case 3: {
                        logger.info("Renamed coordinates of point " + this.geoObjectLabel);
                        output.openItem();
                        output.writePlainText("Point " + this.geoObjectLabel + " has been renamed. ");
                        output.writePointCoordinatesAssignment(this);
                        output.closeItem();
                        break;
                    }
                    case 2: {
                        output.openItem();
                        output.writePlainText("Instantiated condition ");
                        output.writePolynomial(xCondInstance);
                        output.writePlainText(" is added to polynomial system\n");
                        output.closeItem();
                        break;
                    }
                    default: {
                        logger.error("Unknown error during processing");
                        output.closeEnum("itemize");
                        output.openEnum("description");
                        output.openItemWithDesc("Error:");
                        output.closeItemWithDesc("Failed to process the condition");
                        output.closeEnum("description");
                        output.closeSubSection();
                        return -1;
                    }
                }
            }
            output.closeEnum("itemize");
            output.closeSubSection();
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }
}

