/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.geoconstruction.Point;
import java.util.HashMap;

public class TRatioPoint
extends Point {
    public static final String VERSION_NUM = "1.00";
    protected Point u;
    protected Point v;
    protected AMExpression r;

    @Override
    public int getConstructionType() {
        return 11;
    }

    public Point getU() {
        return this.u;
    }

    public Point getV() {
        return this.v;
    }

    public AMExpression getR() {
        return this.r;
    }

    public TRatioPoint(String pointLabel, Point u, Point v, AMExpression r) {
        this.geoObjectLabel = pointLabel;
        this.u = u;
        this.v = v;
        this.r = r;
    }

    @Override
    public Point clone() {
        TRatioPoint p = new TRatioPoint(this.geoObjectLabel, this.u, this.v, this.r);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public int transformToAlgebraicForm() {
        return 0;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Point ");
        sb.append(this.geoObjectLabel);
        sb.append(" verifying [");
        sb.append(this.u.geoObjectLabel);
        sb.append(this.geoObjectLabel);
        sb.append("] = r[");
        sb.append(this.u.geoObjectLabel);
        sb.append(this.v.geoObjectLabel);
        sb.append("], where ");
        sb.append(this.u.geoObjectLabel);
        sb.append(this.geoObjectLabel);
        sb.append(" and ");
        sb.append(this.u.geoObjectLabel);
        sb.append(this.v.geoObjectLabel);
        sb.append(" are perpendicular, and where r = ");
        int size = this.r.size();
        if (size >= 200) {
            sb.append("[too large to be printed : size = " + Integer.toString(size) + "]");
        } else {
            sb.append(this.r.print());
        }
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.u.getGeoObjectLabel(), this.v.getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        Point u2 = this.u;
        Point v2 = this.v;
        if (replacementMap.containsKey(this.u)) {
            u2 = replacementMap.get(this.u);
        }
        if (replacementMap.containsKey(this.v)) {
            v2 = replacementMap.get(this.v);
        }
        return new TRatioPoint(this.geoObjectLabel, u2, v2, this.r);
    }
}

