/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class TangentLine
extends Line {
    public static final String VERSION_NUM = "1.00";
    private static final String M0Label = "0";
    private static final String T0Label = "T0";
    private SetOfPoints underlyingPointsSet = null;
    private int indexOfTouchPoint = -1;
    private SymbolicPolynomial conditionForUnderlyingSetOfPoints = null;

    @Override
    public int getConstructionType() {
        return 45;
    }

    public void setUnderlyingPointsSet(SetOfPoints pointsSet) {
        this.underlyingPointsSet = pointsSet;
    }

    public SetOfPoints getUnderlyingPointsSet() {
        return this.underlyingPointsSet;
    }

    public void setIndexOfTouchPoint(int indexOfTouchPoint) {
        this.indexOfTouchPoint = indexOfTouchPoint;
    }

    public int getIndexOfTouchPoint() {
        return this.indexOfTouchPoint;
    }

    public Point getTouchPoint() {
        return (Point)this.points.get(this.indexOfTouchPoint);
    }

    @Override
    public SymbolicPolynomial getCondition() {
        SymbolicPolynomial conditionForTangentLine = new SymbolicPolynomial();
        SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
        SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
        SymbolicVariable xT = new SymbolicVariable(2, T0Label);
        SymbolicVariable yT = new SymbolicVariable(3, T0Label);
        if (this.conditionForUnderlyingSetOfPoints == null) {
            OpenGeoProver.settings.getLogger().error("Cannot calculate condition for tangent line because condition for underlying set of points is null");
            return null;
        }
        ArrayList<SymbolicPolynomial> derivative = ((SymbolicPolynomial)this.conditionForUnderlyingSetOfPoints.clone()).calcFirstDerivativeByPoint(M0Label);
        if (derivative.get(0) == null || derivative.get(1) == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("First derivative of set of points ");
            sb.append(this.getGeoObjectLabel());
            sb.append(" isn't calculated correcly. ");
            OpenGeoProver.settings.getLogger().error(sb.toString());
            return null;
        }
        derivative.get(0).substitute(T0Label, M0Label);
        derivative.get(1).substitute(T0Label, M0Label);
        SymbolicPolynomial tempPoly = new SymbolicPolynomial();
        SymbolicTerm tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(x0, 1));
        tempPoly.addTerm(tempTerm);
        tempTerm = new SymbolicTerm(-1.0);
        tempTerm.addPower(new Power(xT, 1));
        tempPoly.addTerm(tempTerm);
        conditionForTangentLine = (SymbolicPolynomial)derivative.get(0).clone().multiplyByPolynomial(tempPoly);
        tempPoly = new SymbolicPolynomial();
        tempTerm = new SymbolicTerm(1.0);
        tempTerm.addPower(new Power(y0, 1));
        tempPoly.addTerm(tempTerm);
        tempTerm = new SymbolicTerm(-1.0);
        tempTerm.addPower(new Power(yT, 1));
        tempPoly.addTerm(tempTerm);
        conditionForTangentLine.subtractPolynomial((SymbolicPolynomial)derivative.get(1).clone().multiplyByPolynomial(tempPoly));
        return conditionForTangentLine;
    }

    public TangentLine(String lineLabel, Point basePoint, SetOfPoints pointsSet) {
        this.geoObjectLabel = lineLabel;
        this.points = new Vector();
        if (basePoint != null) {
            this.points.add(basePoint);
        }
        if (pointsSet instanceof Line) {
            OpenGeoProver.settings.getLogger().error("Attempt to set line as tangent's underlying set of points");
            this.underlyingPointsSet = null;
        } else {
            this.underlyingPointsSet = pointsSet;
        }
        if (this.underlyingPointsSet != null && this.underlyingPointsSet.getPoints().indexOf(basePoint) > -1) {
            this.indexOfTouchPoint = 0;
        }
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            Point basePoint = (Point)this.points.get(0);
            if (basePoint == null || this.underlyingPointsSet == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct tangent line " + this.getGeoObjectLabel() + " because some necessary elements are not constructed");
                return false;
            }
            int indexBP = basePoint.getIndex();
            int indexPS = ((GeoConstruction)((Object)this.underlyingPointsSet)).getIndex();
            if (indexBP < 0 || indexPS < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct tangent line " + this.getGeoObjectLabel() + " because some necessary elements are not added to theorem protocol");
                return false;
            }
            if (indexBP >= this.index || indexPS >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct tangent line " + this.getGeoObjectLabel() + " because some necessary elements are not yet constructed");
                return false;
            }
            if (this.indexOfTouchPoint == -1) {
                for (Point tempP : this.points) {
                    int indexP = this.underlyingPointsSet.getPoints().indexOf(tempP);
                    if (indexP <= -1) continue;
                    this.indexOfTouchPoint = this.points.indexOf(tempP);
                    break;
                }
                if (this.indexOfTouchPoint == -1) {
                    IntersectionPoint touchPoint = new IntersectionPoint("GP#" + Math.round(Math.random() * 1000.0), this, this.underlyingPointsSet);
                    output.openItemWithDesc("Info: ");
                    output.closeItemWithDesc("Attempting to add the construction of touch point " + touchPoint.getGeoObjectLabel() + " of tangent line " + this.geoObjectLabel + " and set of points " + ((GeoConstruction)((Object)this.underlyingPointsSet)).getGeoObjectLabel());
                    this.consProtocol.addGeoConstruction(this.index + 1, touchPoint);
                    if (!touchPoint.isValidConstructionStep()) {
                        return false;
                    }
                    this.indexOfTouchPoint = this.points.indexOf(touchPoint);
                    output.openItemWithDesc("Warrning: ");
                    StringBuilder sb = new StringBuilder();
                    sb.append("Created touch point ");
                    sb.append(touchPoint.getGeoObjectLabel());
                    sb.append(" of tangent line ");
                    sb.append(this.getGeoObjectLabel());
                    sb.append(" and set of points ");
                    sb.append(((GeoConstruction)((Object)this.underlyingPointsSet)).getGeoObjectLabel());
                    output.closeItemWithDesc(sb.toString());
                }
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        super.findBestPointsForInstantation(manager);
        if (manager.isErrorFlag()) {
            logger.error("Failed in findBestPointsForInstantation() method from superclass");
            return -1;
        }
        if (manager.getPoint().getPointState() == 3) {
            return 0;
        }
        Point P = manager.getPoint();
        P.setPointState(4);
        Point m0Point = null;
        int limitPointCPIndex = -1;
        if (P.getGeoObjectLabel().equals(this.getTouchPoint().getGeoObjectLabel())) {
            if (this.indexOfTouchPoint == 0) {
                logger.error("findBestPointsForInstantation() method failed in processing condition for tangent line");
                return -1;
            }
            m0Point = (Point)this.points.get(0);
            limitPointCPIndex = P.getIndex();
        } else {
            m0Point = P;
            limitPointCPIndex = P.getIndex() - 1;
        }
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> allConditions = this.getAllPossibleConditionsWithMappings();
        for (SymbolicPolynomial symbCond : allConditions.keySet()) {
            manager.setCondition((SymbolicPolynomial)symbCond.clone());
            boolean isCondForPlainLine = symbCond.equals(LineThroughTwoPoints.conditionForPlainLine);
            ArrayList<String> listOfLabels = symbCond.getAllPointLabels();
            ArrayList<Map<String, Point>> allMappings = allConditions.get(symbCond);
            HashMap<String, Point> pointsMap = null;
            for (Map<String, Point> map : allMappings) {
                Point match;
                boolean badMap = false;
                pointsMap = new HashMap<String, Point>();
                pointsMap.put(M0Label, m0Point.clone());
                if (isCondForPlainLine) {
                    for (String label : listOfLabels) {
                        if (label.equals(M0Label)) continue;
                        match = map.get(label);
                        if (match == null || match.getIndex() >= m0Point.getIndex()) {
                            badMap = true;
                            break;
                        }
                        pointsMap.put(label, match.clone());
                    }
                } else {
                    for (String label : listOfLabels) {
                        if (label.equals(M0Label)) continue;
                        match = map.get(label);
                        if (match == null || !label.equals(T0Label) && match.getIndex() > limitPointCPIndex) {
                            badMap = true;
                            break;
                        }
                        pointsMap.put(label, match.clone());
                    }
                }
                if (badMap) continue;
                manager.processPointsAndCondition(pointsMap);
                if (manager.isErrorFlag()) {
                    logger.error("findBestPointsForInstantation() method failed in processing condition for tangent line");
                    return -1;
                }
                if (manager.getPoint().getPointState() == 3) {
                    return 0;
                }
                P.setPointState(4);
            }
        }
        return 0;
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        SymbolicPolynomial undCond;
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> undMap = this.underlyingPointsSet.getAllPossibleConditionsWithMappings();
        this.conditionForUnderlyingSetOfPoints = undCond = this.underlyingPointsSet.getCondition();
        SymbolicPolynomial tangCond = this.getCondition();
        ArrayList<String> listOfLabels = tangCond.getAllPointLabels();
        ArrayList<Map<String, Point>> allMappings = undMap.get(undCond);
        Point touchPoint = (Point)this.points.get(this.indexOfTouchPoint);
        HashMap<String, Point> pointsMap = null;
        Point m0Point = null;
        int limitPointCPIndex = -1;
        if (P.getGeoObjectLabel().equals(touchPoint.getGeoObjectLabel())) {
            if (this.indexOfTouchPoint == 0) {
                OpenGeoProver.settings.getLogger().error("instantiateConditionFromBasicElements() method failed in processing condition for tangent line");
                return null;
            }
            m0Point = (Point)this.points.get(0);
            limitPointCPIndex = P.getIndex();
        } else {
            m0Point = P;
            limitPointCPIndex = P.getIndex() - 1;
        }
        for (Map<String, Point> map : allMappings) {
            boolean badMap = false;
            pointsMap = new HashMap<String, Point>();
            pointsMap.put(M0Label, m0Point);
            pointsMap.put(T0Label, touchPoint);
            for (String label : listOfLabels) {
                if (label.equals(M0Label) || label.equals(T0Label)) continue;
                Point match = map.get(label);
                if (match == null || match.getIndex() > limitPointCPIndex) {
                    badMap = true;
                    break;
                }
                pointsMap.put(label, match.clone());
            }
            if (badMap) continue;
        }
        return this.instantiateCondition(pointsMap);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = super.getAllPossibleConditionsWithMappings();
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> undMap = this.underlyingPointsSet.getAllPossibleConditionsWithMappings();
        Iterator<SymbolicPolynomial> i$ = undMap.keySet().iterator();
        while (i$.hasNext()) {
            SymbolicPolynomial sp;
            this.conditionForUnderlyingSetOfPoints = sp = i$.next();
            ArrayList<Map<String, Point>> allUndMappings = undMap.get(sp);
            for (Map<String, Point> map : allUndMappings) {
                map.put(T0Label, (Point)this.points.get(this.indexOfTouchPoint));
            }
            retMap.put((SymbolicPolynomial)this.getCondition().clone(), allUndMappings);
        }
        return retMap;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tangent line ");
        sb.append(this.geoObjectLabel);
        sb.append(" through point ");
        sb.append(((Point)this.points.get(0)).getGeoObjectLabel());
        sb.append(" of set of points ");
        sb.append(((GeoConstruction)((Object)this.underlyingPointsSet)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{((Point)this.points.get(0)).getGeoObjectLabel(), ((GeoConstruction)((Object)this.underlyingPointsSet)).getGeoObjectLabel()};
        return inputLabels;
    }
}

