/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SelfConditionalPoint;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TranslatedPoint
extends SelfConditionalPoint {
    public static final String VERSION_NUM = "1.00";
    private static SymbolicPolynomial xConditionForTranslatedPoint;
    private static SymbolicPolynomial yConditionForTranslatedPoint;
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private static final String CLabel = "C";
    private Point pointA = null;
    private Point pointB = null;
    private Point originalPoint = null;

    public void setPointA(Point pointA) {
        this.pointA = pointA;
    }

    public Point getPointA() {
        return this.pointA;
    }

    public void setPointB(Point pointB) {
        this.pointB = pointB;
    }

    public Point getPointB() {
        return this.pointB;
    }

    public void setOriginalPoint(Point originalPoint) {
        this.originalPoint = originalPoint;
    }

    public Point getOriginalPoint() {
        return this.originalPoint;
    }

    @Override
    public int getConstructionType() {
        return 5;
    }

    @Override
    public SymbolicPolynomial getXCondition() {
        return xConditionForTranslatedPoint;
    }

    @Override
    public SymbolicPolynomial getYCondition() {
        return yConditionForTranslatedPoint;
    }

    public TranslatedPoint(String pointLabel, Point A, Point B, Point originalPoint) {
        this.geoObjectLabel = pointLabel;
        this.pointA = A;
        this.pointB = B;
        this.originalPoint = originalPoint;
    }

    @Override
    public Point clone() {
        TranslatedPoint p = new TranslatedPoint(this.geoObjectLabel, this.pointA, this.pointB, this.originalPoint);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            if (this.pointA == null || this.pointB == null || this.originalPoint == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Translated point " + this.getGeoObjectLabel() + " can't be constructed since one or two vector's points or original point are not constructed");
                return false;
            }
            int indexA = this.pointA.getIndex();
            int indexB = this.pointB.getIndex();
            int indexOP = this.originalPoint.getIndex();
            if (indexA < 0 || indexB < 0 || indexOP < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Translated point " + this.getGeoObjectLabel() + " can't be constructed since some of vector's points or original point is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexA && this.index > indexB && this.index > indexOP;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Translated point " + this.getGeoObjectLabel() + " can't be constructed since some of vector's points or original point is not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Translated point ");
        sb.append(this.geoObjectLabel);
        sb.append(" of point ");
        sb.append(this.originalPoint.getGeoObjectLabel());
        sb.append(" for vector ");
        sb.append(this.pointA.getGeoObjectLabel());
        sb.append(this.pointB.getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.pointA.getGeoObjectLabel(), this.pointB.getGeoObjectLabel(), this.originalPoint.getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Map<String, Point> getPointsForInstantiation() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, this);
        pointsMap.put(ALabel, this.pointA);
        pointsMap.put(BLabel, this.pointB);
        pointsMap.put(CLabel, this.originalPoint);
        return pointsMap;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        OpenGeoProver.settings.getLogger().error("This method should not be called on this class.");
        return null;
    }

    static {
        SymbolicTerm t;
        xConditionForTranslatedPoint = null;
        yConditionForTranslatedPoint = null;
        if (xConditionForTranslatedPoint == null) {
            xConditionForTranslatedPoint = new SymbolicPolynomial();
            SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            SymbolicVariable xC = new SymbolicVariable(2, CLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(x0, 1));
            xConditionForTranslatedPoint.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 1));
            xConditionForTranslatedPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xB, 1));
            xConditionForTranslatedPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xC, 1));
            xConditionForTranslatedPoint.addTerm(t);
        }
        if (yConditionForTranslatedPoint == null) {
            yConditionForTranslatedPoint = new SymbolicPolynomial();
            SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            SymbolicVariable yC = new SymbolicVariable(3, CLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(y0, 1));
            yConditionForTranslatedPoint.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yA, 1));
            yConditionForTranslatedPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yB, 1));
            yConditionForTranslatedPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yC, 1));
            yConditionForTranslatedPoint.addTerm(t);
        }
    }
}

