/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoobject;

import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.PointList;
import java.util.Vector;

public class Angle
implements PointList {
    public static final String VERSION_NUM = "1.00";
    private Point vertex;
    private Point firstRayPoint;
    private Point secondRayPoint;
    private String angLabel;

    public void setVertex(Point vertex) {
        this.vertex = vertex;
    }

    public Point getVertex() {
        return this.vertex;
    }

    public void setFirstRayPoint(Point firstRayPoint) {
        this.firstRayPoint = firstRayPoint;
    }

    public Point getFirstRayPoint() {
        return this.firstRayPoint;
    }

    public void setSecondRayPoint(Point secondRayPoint) {
        this.secondRayPoint = secondRayPoint;
    }

    public Point getSecondRayPoint() {
        return this.secondRayPoint;
    }

    @Override
    public String getGeoObjectLabel() {
        return this.angLabel;
    }

    public Angle(Point firstRayPoint, Point vertex, Point secondRayPoint) {
        this.vertex = vertex;
        this.firstRayPoint = firstRayPoint;
        this.secondRayPoint = secondRayPoint;
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(firstRayPoint.getGeoObjectLabel());
        sb.append(vertex.getGeoObjectLabel());
        sb.append(secondRayPoint.getGeoObjectLabel());
        this.angLabel = sb.toString();
    }

    public Angle(Point firstRayPoint, Point vertex, Point secondRayPoint, String label) {
        this(firstRayPoint, vertex, secondRayPoint);
        this.angLabel = label;
    }

    public boolean isFirstRayPerpendicularToXAxis() {
        return this.vertex.getX().equals(this.firstRayPoint.getX());
    }

    public boolean isSecondRayPerpendicularToXAxis() {
        return this.vertex.getX().equals(this.secondRayPoint.getX());
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.firstRayPoint.getGeoObjectLabel());
        sb.append(this.vertex.getGeoObjectLabel());
        sb.append(this.secondRayPoint.getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public Vector<Point> getPoints() {
        Vector<Point> points = new Vector<Point>();
        points.add(this.firstRayPoint);
        points.add(this.vertex);
        points.add(this.secondRayPoint);
        return points;
    }
}

