/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoobject;

import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.PointList;
import java.util.Vector;

public class PolygonLine
implements PointList {
    public static final String VERSION_NUM = "1.00";
    private Vector<Point> vertices;
    private String label;
    private Vector<String> edgesLabels;

    public void setVertices(Vector<Point> vertices) {
        this.vertices = vertices;
    }

    public Vector<Point> getVertices() {
        return this.vertices;
    }

    @Override
    public String getGeoObjectLabel() {
        return this.label;
    }

    public void setEdgesLabels(Vector<String> edgesLabels) {
        this.edgesLabels = edgesLabels;
    }

    public Vector<String> getEdgesLabels() {
        return this.edgesLabels;
    }

    public PolygonLine(Vector<Point> vertices, Vector<String> edges) {
        this.vertices = vertices;
        this.edgesLabels = edges;
        StringBuilder sb = new StringBuilder();
        sb.append("|");
        for (Point pt : vertices) {
            sb.append(pt.getGeoObjectLabel());
        }
        sb.append("|");
        this.label = sb.toString();
    }

    public PolygonLine(Vector<Point> vertices, Vector<String> edges, String label) {
        this.vertices = vertices;
        this.edgesLabels = edges;
        this.label = label;
    }

    public boolean containsPointAsVertex(Point pt) {
        return this.vertices.contains(pt);
    }

    public boolean containsPointAsVertex(String ptLabel) {
        FreePoint tempPt = new FreePoint(ptLabel);
        return this.containsPointAsVertex(tempPt);
    }

    @Override
    public Vector<Point> getPoints() {
        return this.vertices;
    }
}

