/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoobject;

import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.GeneralizedSegment;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.PointList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class Segment
implements GeneralizedSegment,
PointList {
    public static final String VERSION_NUM = "1.00";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private static SymbolicPolynomial squareOfDistance;
    private static SymbolicPolynomial xCoordOfOrientedSeg;
    private static SymbolicPolynomial yCoordOfOrientedSeg;
    private Point firstEndPoint = null;
    private Point secondEndPoint = null;
    private String segLabel = null;

    public void setFirstEndPoint(Point firstEndPoint) {
        this.firstEndPoint = firstEndPoint;
    }

    public Point getFirstEndPoint() {
        return this.firstEndPoint;
    }

    public void setSecondEndPoint(Point secondEndPoint) {
        this.secondEndPoint = secondEndPoint;
    }

    public Point getSecondEndPoint() {
        return this.secondEndPoint;
    }

    @Override
    public String getGeoObjectLabel() {
        return this.segLabel;
    }

    public Segment(Point firstP, Point secondP) {
        this.firstEndPoint = firstP;
        this.secondEndPoint = secondP;
        StringBuilder sb = new StringBuilder();
        sb.append("|");
        sb.append(firstP.getGeoObjectLabel());
        sb.append(secondP.getGeoObjectLabel());
        sb.append("|");
        this.segLabel = sb.toString();
    }

    public Segment(Point firstP, Point secondP, String label) {
        this(firstP, secondP);
        this.segLabel = label;
    }

    public static Map<String, Point> getPointsMapForSquareOfDistance(Point pointA, Point pointB) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, pointA);
        pointsMap.put(BLabel, pointB);
        return pointsMap;
    }

    public static Map<String, String> getLabelsMapForSquareOfDistance(String labelA, String labelB) {
        HashMap<String, String> labelsMap = new HashMap<String, String>();
        labelsMap.put(ALabel, labelA);
        labelsMap.put(BLabel, labelB);
        return labelsMap;
    }

    public static SymbolicPolynomial substitutePointLabelsForSquareOfDistance(SymbolicPolynomial symbPoly, String labelA, String labelB) {
        Map<String, String> labelsMap = Segment.getLabelsMapForSquareOfDistance(labelA, labelB);
        return symbPoly.substitute(labelsMap);
    }

    public static SymbolicPolynomial getConditionForSquareOfDistance() {
        return squareOfDistance;
    }

    public static SymbolicPolynomial getSubstitutedConditionForSquareOfDistance(String labelA, String labelB) {
        HashMap<String, String> labelsMap = new HashMap<String, String>();
        labelsMap.put(ALabel, labelA);
        labelsMap.put(BLabel, labelB);
        return ((SymbolicPolynomial)squareOfDistance.clone()).substitute(labelsMap);
    }

    @Override
    public XPolynomial getInstantiatedConditionForSquareOfSegment() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, this.firstEndPoint);
        pointsMap.put(BLabel, this.secondEndPoint);
        return OGPTP.instantiateCondition(squareOfDistance, pointsMap);
    }

    public XPolynomial getInstantiatedXCoordinateOfOrientedSegment() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, this.firstEndPoint);
        pointsMap.put(BLabel, this.secondEndPoint);
        return OGPTP.instantiateCondition(xCoordOfOrientedSeg, pointsMap);
    }

    public XPolynomial getInstantiatedYCoordinateOfOrientedSegment() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, this.firstEndPoint);
        pointsMap.put(BLabel, this.secondEndPoint);
        return OGPTP.instantiateCondition(yCoordOfOrientedSeg, pointsMap);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.firstEndPoint.getGeoObjectLabel());
        sb.append(this.secondEndPoint.getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public Vector<Point> getPoints() {
        Vector<Point> points = new Vector<Point>();
        points.add(this.firstEndPoint);
        points.add(this.secondEndPoint);
        return points;
    }

    static {
        SymbolicTerm t;
        SymbolicVariable xA;
        squareOfDistance = null;
        xCoordOfOrientedSeg = null;
        yCoordOfOrientedSeg = null;
        if (squareOfDistance == null) {
            squareOfDistance = new SymbolicPolynomial();
            xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            SymbolicTerm t2 = new SymbolicTerm(1.0);
            t2.addPower(new Power(xA, 2));
            squareOfDistance.addTerm(t2);
            t2 = new SymbolicTerm(1.0);
            t2.addPower(new Power(xB, 2));
            squareOfDistance.addTerm(t2);
            t2 = new SymbolicTerm(1.0);
            t2.addPower(new Power(yA, 2));
            squareOfDistance.addTerm(t2);
            t2 = new SymbolicTerm(1.0);
            t2.addPower(new Power(yB, 2));
            squareOfDistance.addTerm(t2);
            t2 = new SymbolicTerm(-2.0);
            t2.addPower(new Power(xA, 1));
            t2.addPower(new Power(xB, 1));
            squareOfDistance.addTerm(t2);
            t2 = new SymbolicTerm(-2.0);
            t2.addPower(new Power(yA, 1));
            t2.addPower(new Power(yB, 1));
            squareOfDistance.addTerm(t2);
        }
        if (xCoordOfOrientedSeg == null) {
            xCoordOfOrientedSeg = new SymbolicPolynomial();
            xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xB, 1));
            xCoordOfOrientedSeg.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 1));
            xCoordOfOrientedSeg.addTerm(t);
        }
        if (yCoordOfOrientedSeg == null) {
            yCoordOfOrientedSeg = new SymbolicPolynomial();
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yB, 1));
            yCoordOfOrientedSeg.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yA, 1));
            yCoordOfOrientedSeg.addTerm(t);
        }
    }
}

