/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.ndgcondition;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.FourPointsPositionChecker;
import com.ogprover.pp.tp.auxiliary.PointListManager;
import com.ogprover.pp.tp.auxiliary.PointsPositionChecker;
import com.ogprover.pp.tp.auxiliary.ThreePointsPositionChecker;
import com.ogprover.pp.tp.auxiliary.TwoPointsPositionChecker;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.ParametricSet;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromSetOfPoints;
import com.ogprover.utilities.logger.ILogger;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;

public class AlgebraicNDGCondition {
    public static final String VERSION_NUM = "1.00";
    private OGPTP consProtocol = null;
    private XPolynomial polynomial = null;
    private Vector<Vector<Point>> pointLists = null;
    private Vector<String> textList = null;
    private String bestDescription = null;
    private Vector<Point> bestPointList = null;
    private int numOfFreePts = 0;
    private int numOfRndPts = 0;
    private int numOfDependentPts = 0;
    private int numOfAllPts = 0;
    public static final String NDG_TYPE_POLYNOMIAL = "IsPolynomial";
    public static final String NDG_TYPE_2PT_IDENTICAL = "AreEqual";
    public static final String NDG_TYPE_3PT_COLLINEAR = "AreCollinear";
    public static final String NDG_TYPE_3PT_MIDPOINT = "IsMidpointOf";
    public static final String NDG_TYPE_3PT_ON_PERP_BIS = "IsOnBisector";
    public static final String NDG_TYPE_3PT_RIGHT_ANG = "ArePerpendicular";
    public static final String NDG_TYPE_3PT_ON_CIRCLE = "IsOnCircle";
    public static final String NDG_TYPE_3PT_SEG_SUM = "IsSumOf";
    public static final String NDG_TYPE_4PT_COLLINEAR = "AreCollinear";
    public static final String NDG_TYPE_4PT_CONCYCLIC = "AreConcyclic";
    public static final String NDG_TYPE_4PT_EQ_SEG = "AreEqual";
    public static final String NDG_TYPE_4PT_PARALLEL = "AreParallel";
    public static final String NDG_TYPE_4PT_PERPENDICULAR = "ArePerpendicular";
    public static final String NDG_TYPE_4PT_HARMONIC = "AreHarmonic";
    public static final String NDG_TYPE_4PT_CONG_COLL_SEG = "AreCollinearCongruentSegments";
    public static final String NDG_TYPE_4PT_ON_ANG_BIS = "IsOnAngleBisector";
    public static final String NDG_TYPE_4PT_2_ON_CIRCLE = "AreOnCircle";
    public static final String NDG_TYPE_4PT_ON_CIRCLE = "AreOnCircle";
    public static final String NDG_TYPE_4PT_INVERSE = "AreInverses";
    public static final String NDG_TYPE_4PT_2_ON_PERP_BIS = "AreOnPerpendicularBisector";
    public static final String NDG_TYPE_4PT_TOUCH_CIRCLES = "AreTouchingCircles";
    private String ndgType;

    public void setConsProtocol(OGPTP consProtocol) {
        this.consProtocol = consProtocol;
    }

    public OGPTP getConsProtocol() {
        return this.consProtocol;
    }

    public void setPolynomial(XPolynomial polynomial) {
        this.polynomial = polynomial;
    }

    public XPolynomial getPolynomial() {
        return this.polynomial;
    }

    public void setPointLists(Vector<Vector<Point>> pointLists) {
        this.pointLists = pointLists;
    }

    public Vector<Vector<Point>> getPointLists() {
        return this.pointLists;
    }

    public void setText(Vector<String> textL) {
        this.textList = textL;
    }

    public Vector<String> getText() {
        return this.textList;
    }

    public void setBestDescription(String bestDescription) {
        this.bestDescription = bestDescription;
    }

    public String getBestDescription() {
        return this.bestDescription;
    }

    public void setBestPointList(Vector<Point> bestPointList) {
        this.bestPointList = bestPointList;
    }

    public Vector<Point> getBestPointList() {
        return this.bestPointList;
    }

    public void setNumOfFreePts(int numOfFreePts) {
        this.numOfFreePts = numOfFreePts;
    }

    public int getNumOfFreePts() {
        return this.numOfFreePts;
    }

    public void setNumOfRndPts(int numOfRndPts) {
        this.numOfRndPts = numOfRndPts;
    }

    public int getNumOfRndPts() {
        return this.numOfRndPts;
    }

    public void setNumOfDependentPts(int numOfDependentPts) {
        this.numOfDependentPts = numOfDependentPts;
    }

    public int getNumOfDependentPts() {
        return this.numOfDependentPts;
    }

    public void setNumOfAllPts(int numOfAllPts) {
        this.numOfAllPts = numOfAllPts;
    }

    public int getNumOfAllPts() {
        return this.numOfAllPts;
    }

    public String getNdgType() {
        return this.ndgType;
    }

    public void setNdgType(String ndgType) {
        this.ndgType = ndgType;
    }

    public AlgebraicNDGCondition(XPolynomial ndgPoly) {
        this.polynomial = ((XPolynomial)ndgPoly.clone()).reduceUTerms(false);
        this.ndgType = NDG_TYPE_POLYNOMIAL;
    }

    public void addNewTranslation(String ndgType, Vector<Point> pointList) {
        if (this.textList == null) {
            this.textList = new Vector();
        }
        String textStr = AlgebraicNDGCondition.getNDGConditionText(ndgType, pointList);
        this.textList.add(textStr);
        if (this.bestDescription == null) {
            this.ndgType = ndgType;
            this.bestDescription = textStr;
            this.bestPointList = pointList;
            this.numOfAllPts = pointList.size();
            this.numOfFreePts = 0;
            this.numOfRndPts = 0;
            this.numOfDependentPts = 0;
            for (Point pt : pointList) {
                if (pt instanceof FreePoint) {
                    ++this.numOfFreePts;
                    continue;
                }
                if (pt instanceof RandomPointFromSetOfPoints) {
                    ++this.numOfRndPts;
                    continue;
                }
                ++this.numOfDependentPts;
            }
        } else {
            int newNumOfAllPts = pointList.size();
            int newNumOfFreePts = 0;
            int newNumOfRndPts = 0;
            int newNumOfDependentPts = 0;
            for (Point pt : pointList) {
                if (pt instanceof FreePoint) {
                    ++newNumOfFreePts;
                    continue;
                }
                if (pt instanceof RandomPointFromSetOfPoints) {
                    ++newNumOfRndPts;
                    continue;
                }
                ++newNumOfDependentPts;
            }
            if (this.numOfDependentPts > newNumOfDependentPts || this.numOfFreePts < newNumOfFreePts || this.numOfAllPts > newNumOfAllPts || this.bestDescription.length() > textStr.length()) {
                this.numOfAllPts = newNumOfAllPts;
                this.numOfFreePts = newNumOfFreePts;
                this.numOfRndPts = newNumOfRndPts;
                this.numOfDependentPts = newNumOfDependentPts;
                this.ndgType = ndgType;
                this.bestDescription = textStr;
                this.bestPointList = pointList;
            }
        }
    }

    private int populatePointLists() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        Vector<UXVariable> varList = this.polynomial.extractAllVariables();
        if (varList == null) {
            logger.error("Failed to extract variables from polynomial of NDG condition");
            return -1;
        }
        Map<UXVariable, Vector<Point>> pointsOfVars = this.consProtocol.getPointsAssociatedWithVariables(varList);
        if (pointsOfVars == null) {
            logger.error("Failed to retrieve points from CP associated to list of extracted variables");
            return -1;
        }
        Collection<Vector<Point>> pointsOfVarsC = pointsOfVars.values();
        if (pointsOfVarsC == null) {
            logger.error("Failed to extract lists of points from map with variables and their associated points.");
            return -1;
        }
        Vector<Vector<Point>> pointsOfVarsV = new Vector<Vector<Point>>(pointsOfVarsC);
        Vector<Vector<Vector<Point>>> combinationsV = new Vector<Vector<Vector<Point>>>();
        for (Vector<Point> comb : pointsOfVarsV) {
            combinationsV.add(PointListManager.createListOfCombinations(comb));
        }
        boolean bFirst = true;
        Vector<Vector<Point>> mergedPoints = new Vector<Vector<Point>>();
        for (Vector<Vector<Point>> vector : combinationsV) {
            if (bFirst) {
                mergedPoints = vector;
                bFirst = false;
                continue;
            }
            mergedPoints = PointListManager.mergePairsOfPointCombinations(mergedPoints, vector);
        }
        mergedPoints = PointListManager.mergePairsOfPointCombinations(mergedPoints, this.consProtocol.getZeroPoints());
        this.pointLists = new Vector();
        for (Vector vector : mergedPoints) {
            int vpsiz = vector.size();
            if (vpsiz < 2 || vpsiz > 4) continue;
            this.pointLists.add(vector);
        }
        return 0;
    }

    public boolean checkInParametricObjects() {
        boolean result = false;
        for (GeoConstruction geoCons : this.consProtocol.getConstructionSteps()) {
            if (!(geoCons instanceof ParametricSet)) continue;
            ((ParametricSet)geoCons).processNDGCondition(this);
            result = true;
        }
        return result;
    }

    public int transformToUserReadableForm() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (this.populatePointLists() != 0) {
            if (this.checkInParametricObjects()) {
                return 0;
            }
            logger.error("Failed to populate points for NDG condition.");
            return -1;
        }
        TwoPointsPositionChecker twoPtsPosChecker = new TwoPointsPositionChecker(this);
        ThreePointsPositionChecker threePtsPosChecker = new ThreePointsPositionChecker(this);
        FourPointsPositionChecker fourPtsPosChecker = new FourPointsPositionChecker(this);
        for (Vector<Point> pointsV : this.pointLists) {
            switch (pointsV.size()) {
                case 2: {
                    ((PointsPositionChecker)twoPtsPosChecker).checkPositions(pointsV);
                    break;
                }
                case 3: {
                    ((PointsPositionChecker)threePtsPosChecker).checkPositions(pointsV);
                    break;
                }
                case 4: {
                    ((PointsPositionChecker)fourPtsPosChecker).checkPositions(pointsV);
                    break;
                }
            }
        }
        return 0;
    }

    public static String getNDGConditionText(String ndgType, Vector<Point> points) {
        Point pt1 = points.get(0);
        Point pt2 = points.get(1);
        Point pt3 = points.size() > 2 ? points.get(2) : null;
        Point pt4 = points.size() > 3 ? points.get(3) : null;
        StringBuilder sb = new StringBuilder();
        if (ndgType == "AreEqual") {
            sb.append("Points ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" are not identical");
            return sb.toString();
        }
        if (ndgType == "AreCollinear") {
            sb.append("Points ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(", ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" are not collinear");
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_3PT_MIDPOINT) {
            sb.append("Point ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" is not the midpoint of segment with endpoints ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_3PT_ON_PERP_BIS) {
            sb.append("Point ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" is not on perpendicular bisector of segment with endpoints ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == "ArePerpendicular") {
            sb.append("Line through points ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" is not perpendicular to line through points ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_3PT_ON_CIRCLE) {
            sb.append("Point ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" is not on circle with center ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and point from it ");
            sb.append(pt2.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_3PT_SEG_SUM) {
            sb.append("Segment with endpoints ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" is not sum of two segments: segment with endpoints ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and segment with endpoints ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == "AreCollinear") {
            sb.append("Points ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(", ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(", ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt4.getGeoObjectLabel());
            sb.append(" are not collinear");
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_4PT_CONCYCLIC) {
            sb.append("Points ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(", ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(", ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt4.getGeoObjectLabel());
            sb.append(" are not concyclic");
            return sb.toString();
        }
        if (ndgType == "AreEqual") {
            sb.append("Segment with endpoints ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" and segment with endpoints ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt4.getGeoObjectLabel());
            sb.append(" are not of same lengths");
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_4PT_PARALLEL) {
            sb.append("Line through points ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" is not parallel with line through points ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt4.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == "ArePerpendicular") {
            sb.append("Line through points ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" is not perpendicular to line through points ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt4.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_4PT_HARMONIC) {
            sb.append("Pair of points ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" is not in harmonic conjunction with pair of points ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt4.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_4PT_CONG_COLL_SEG) {
            sb.append("Segment with endpoints ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" is not collinear and congruent with segment with endpoints ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt4.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_4PT_ON_ANG_BIS) {
            sb.append("Point ");
            sb.append(pt4.getGeoObjectLabel());
            sb.append(" is not on angle bisector of angle with vertex ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" and two points from different rays ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt3.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == "AreOnCircle") {
            sb.append("Points ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt4.getGeoObjectLabel());
            sb.append(" are not together on circle with center ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and one point on it ");
            sb.append(pt2.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == "AreOnCircle") {
            sb.append("Point ");
            sb.append(pt4.getGeoObjectLabel());
            sb.append(" is not on circle with center ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and radius equal to segment with endpoints ");
            sb.append(pt2.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt3.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_4PT_INVERSE) {
            sb.append("Points ");
            sb.append(pt3.getGeoObjectLabel());
            sb.append(" and ");
            sb.append(pt4.getGeoObjectLabel());
            sb.append(" are not two inverse points with respect to circle with center ");
            sb.append(pt1.getGeoObjectLabel());
            sb.append(" and one point from it ");
            sb.append(pt2.getGeoObjectLabel());
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_4PT_2_ON_PERP_BIS) {
            return sb.toString();
        }
        if (ndgType == NDG_TYPE_4PT_TOUCH_CIRCLES) {
            return sb.toString();
        }
        return null;
    }
}

