/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.GeneralizedSegment;
import com.ogprover.pp.tp.auxiliary.ProductOfTwoSegments;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.Vector;

public class AlgebraicSumOfThreeSegments
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private GeneralizedSegment firstSegment = null;
    private GeneralizedSegment secondSegment = null;
    private GeneralizedSegment thirdSegment = null;

    public void setFirstSegment(GeneralizedSegment firstSegment) {
        this.firstSegment = firstSegment;
    }

    public GeneralizedSegment getFirstSegment() {
        return this.firstSegment;
    }

    public void setSecondSegment(GeneralizedSegment secondSegment) {
        this.secondSegment = secondSegment;
    }

    public GeneralizedSegment getSecondSegment() {
        return this.secondSegment;
    }

    public void setThirdSegment(GeneralizedSegment thirdSegment) {
        this.thirdSegment = thirdSegment;
    }

    public GeneralizedSegment getThirdSegment() {
        return this.thirdSegment;
    }

    public AlgebraicSumOfThreeSegments(Point A, Point B, Point C, Point D, Point E, Point F) {
        this.geoObjects = new Vector();
        this.geoObjects.add(A);
        this.geoObjects.add(B);
        this.geoObjects.add(C);
        this.geoObjects.add(D);
        this.geoObjects.add(E);
        this.geoObjects.add(F);
        this.firstSegment = new Segment(A, B);
        this.secondSegment = new Segment(C, D);
        this.thirdSegment = new Segment(E, F);
    }

    public AlgebraicSumOfThreeSegments(GeneralizedSegment firstSeg, GeneralizedSegment secondSeg, GeneralizedSegment thirdSeg) {
        Segment b;
        Segment a;
        GeneralizedSegment seg;
        this.firstSegment = firstSeg;
        this.secondSegment = secondSeg;
        this.thirdSegment = thirdSeg;
        this.geoObjects = new Vector();
        if (firstSeg instanceof Segment) {
            seg = (Segment)firstSeg;
            this.geoObjects.add(((Segment)seg).getFirstEndPoint());
            this.geoObjects.add(((Segment)seg).getSecondEndPoint());
        } else if (firstSeg instanceof ProductOfTwoSegments) {
            seg = (ProductOfTwoSegments)firstSeg;
            a = ((ProductOfTwoSegments)seg).getFirstSegment();
            b = ((ProductOfTwoSegments)seg).getSecondSegment();
            this.geoObjects.add(a.getFirstEndPoint());
            this.geoObjects.add(a.getSecondEndPoint());
            this.geoObjects.add(b.getFirstEndPoint());
            this.geoObjects.add(b.getSecondEndPoint());
        }
        if (secondSeg instanceof Segment) {
            seg = (Segment)secondSeg;
            this.geoObjects.add(((Segment)seg).getFirstEndPoint());
            this.geoObjects.add(((Segment)seg).getSecondEndPoint());
        } else if (secondSeg instanceof ProductOfTwoSegments) {
            seg = (ProductOfTwoSegments)secondSeg;
            a = ((ProductOfTwoSegments)seg).getFirstSegment();
            b = ((ProductOfTwoSegments)seg).getSecondSegment();
            this.geoObjects.add(a.getFirstEndPoint());
            this.geoObjects.add(a.getSecondEndPoint());
            this.geoObjects.add(b.getFirstEndPoint());
            this.geoObjects.add(b.getSecondEndPoint());
        }
        if (thirdSeg instanceof Segment) {
            seg = (Segment)thirdSeg;
            this.geoObjects.add(((Segment)seg).getFirstEndPoint());
            this.geoObjects.add(((Segment)seg).getSecondEndPoint());
        } else if (thirdSeg instanceof ProductOfTwoSegments) {
            seg = (ProductOfTwoSegments)thirdSeg;
            a = ((ProductOfTwoSegments)seg).getFirstSegment();
            b = ((ProductOfTwoSegments)seg).getSecondSegment();
            this.geoObjects.add(a.getFirstEndPoint());
            this.geoObjects.add(a.getSecondEndPoint());
            this.geoObjects.add(b.getFirstEndPoint());
            this.geoObjects.add(b.getSecondEndPoint());
        }
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        XPolynomial statementPoly = new XPolynomial();
        XPolynomial sqra = this.firstSegment.getInstantiatedConditionForSquareOfSegment();
        XPolynomial sqrb = this.secondSegment.getInstantiatedConditionForSquareOfSegment();
        XPolynomial sqrc = this.thirdSegment.getInstantiatedConditionForSquareOfSegment();
        statementPoly.addPolynomial(sqra.clone().multiplyByPolynomial(sqra));
        statementPoly.addPolynomial(sqrb.clone().multiplyByPolynomial(sqrb));
        statementPoly.addPolynomial(sqrc.clone().multiplyByPolynomial(sqrc));
        statementPoly.addPolynomial(sqra.clone().multiplyByPolynomial(sqrb).multiplyByRealConstant(-2.0));
        statementPoly.addPolynomial(sqra.clone().multiplyByPolynomial(sqrc).multiplyByRealConstant(-2.0));
        statementPoly.addPolynomial(sqrb.clone().multiplyByPolynomial(sqrc).multiplyByRealConstant(-2.0));
        return statementPoly;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Algebraic sum of segments ");
        sb.append(this.firstSegment.getDescription());
        sb.append(", ");
        sb.append(this.secondSegment.getDescription());
        sb.append(" and ");
        sb.append(this.thirdSegment.getDescription());
        sb.append(" is zero");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("Statement not currently supported by the area method.");
        return null;
    }
}

