/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.GeneralizedAngleTangent;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SpecialConstantAngle;
import com.ogprover.pp.tp.geoobject.Angle;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class AngleEqualToSpecialConstantAngle
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    public static final String ALabel = "A";
    public static final String OLabel = "O";
    public static final String BLabel = "B";
    public static final String alphaLabel = "alpha";
    private Angle varAngle = null;
    private SpecialConstantAngle consAngle = null;

    public void setVarAngle(Angle varAngle) {
        this.varAngle = varAngle;
    }

    public Angle getVarAngle() {
        return this.varAngle;
    }

    public void setConsAngle(SpecialConstantAngle consAngle) {
        this.consAngle = consAngle;
    }

    public SpecialConstantAngle getConsAngle() {
        return this.consAngle;
    }

    public AngleEqualToSpecialConstantAngle(Point A, Point O, Point B, SpecialConstantAngle alpha) {
        this.geoObjects = new Vector();
        this.geoObjects.add(A);
        this.geoObjects.add(O);
        this.geoObjects.add(B);
        this.varAngle = new Angle(A, O, B);
        this.consAngle = alpha;
    }

    public AngleEqualToSpecialConstantAngle(Angle varAngle, SpecialConstantAngle alpha) {
        this.varAngle = varAngle;
        this.consAngle = alpha;
        this.geoObjects = new Vector();
        this.geoObjects.add(varAngle.getFirstRayPoint());
        this.geoObjects.add(varAngle.getVertex());
        this.geoObjects.add(varAngle.getSecondRayPoint());
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, (Point)this.geoObjects.get(0));
        pointsMap.put(OLabel, (Point)this.geoObjects.get(1));
        pointsMap.put(BLabel, (Point)this.geoObjects.get(2));
        pointsMap.put(alphaLabel, this.consAngle.getParametricPoint());
        ArrayList<SymbolicPolynomial> tg = GeneralizedAngleTangent.getSubstitutedConditionForTangent(ALabel, OLabel, BLabel);
        SymbolicPolynomial condition = tg.get(0);
        SymbolicTerm st = new SymbolicTerm(1.0);
        st.addPower(new Power(new SymbolicVariable(2, alphaLabel), 1));
        condition.subtractPolynomial(tg.get(1).multiplyByTerm(st));
        return OGPTP.instantiateCondition(condition, pointsMap);
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Angle ");
        sb.append(this.varAngle.getDescription());
        sb.append(" is equal to angle ");
        sb.append(((GeoConstruction)((Object)this.consAngle)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("Statement not currently supported by the area method.");
        return null;
    }
}

