/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CollinearPoints
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";

    public CollinearPoints(ArrayList<Point> pointList) {
        if (pointList == null || pointList.size() < 3) {
            OpenGeoProver.settings.getLogger().error("There should be at least three points for statement about collinear points.");
            return;
        }
        this.geoObjects = new Vector();
        for (Point p : pointList) {
            this.geoObjects.add(p);
        }
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        XPolynomial tempCond = null;
        XPolynomial tempAddend = null;
        XPolynomial bestCondition = null;
        int degreeOfBestCondition = 0;
        for (GeoConstruction geoCons : this.consProtocol.getConstructionSteps()) {
            if (!(geoCons instanceof Line)) continue;
            Line l = (Line)geoCons;
            Vector<Point> lPoints = l.getPoints();
            ArrayList<Point> pointsFromLine = new ArrayList<Point>();
            PointSetRelationshipManager manager = null;
            tempCond = new XPolynomial();
            for (GeoConstruction gc : this.geoObjects) {
                Point p = (Point)gc;
                if (lPoints.indexOf(p) < 0) continue;
                pointsFromLine.add(p);
            }
            if (pointsFromLine.size() < 2) continue;
            int numPointsLeft = this.geoObjects.size() - pointsFromLine.size();
            for (GeoConstruction gc : this.geoObjects) {
                Point p = (Point)gc;
                if (pointsFromLine.indexOf(p) >= 0) continue;
                manager = new PointSetRelationshipManager(l, p, 1);
                tempAddend = manager.retrieveInstantiatedCondition();
                if (numPointsLeft == 1) {
                    tempCond.addPolynomial(tempAddend);
                    break;
                }
                tempCond.addPolynomial(tempAddend.clone().multiplyByPolynomial(tempAddend));
                if (--numPointsLeft != 0) continue;
                break;
            }
            int tempDegree = tempCond.getPolynomialDegree();
            if (bestCondition != null && tempDegree >= degreeOfBestCondition && (tempDegree != degreeOfBestCondition || tempCond.getTerms().size() >= bestCondition.getTerms().size())) continue;
            bestCondition = tempCond;
            degreeOfBestCondition = tempDegree;
        }
        boolean isOnePointLeft = this.geoObjects.size() == 3;
        int jj1 = this.geoObjects.size();
        for (int ii1 = 0; ii1 < jj1; ++ii1) {
            Point p1 = (Point)this.geoObjects.get(ii1);
            int jj2 = this.geoObjects.size();
            for (int ii2 = 0; ii2 < jj2; ++ii2) {
                Point p2 = (Point)this.geoObjects.get(ii2);
                if (p2.getGeoObjectLabel().equals(p1.getGeoObjectLabel())) continue;
                LineThroughTwoPoints l = new LineThroughTwoPoints("tempLine", p1, p2);
                tempCond = new XPolynomial();
                int jj = this.geoObjects.size();
                for (int ii = 0; ii < jj; ++ii) {
                    Point p = (Point)this.geoObjects.get(ii);
                    if (p.getGeoObjectLabel().equals(p1.getGeoObjectLabel()) || p.getGeoObjectLabel().equals(p2.getGeoObjectLabel())) continue;
                    tempAddend = l.instantiateConditionFromBasicElements(p);
                    if (isOnePointLeft) {
                        tempCond.addPolynomial(tempAddend);
                        break;
                    }
                    tempCond.addPolynomial(tempAddend.clone().multiplyByPolynomial(tempAddend));
                }
                int tempDegree = tempCond.getPolynomialDegree();
                if (bestCondition != null && tempDegree >= degreeOfBestCondition && (tempDegree != degreeOfBestCondition || tempCond.getTerms().size() >= bestCondition.getTerms().size())) continue;
                bestCondition = tempCond;
                degreeOfBestCondition = tempDegree;
            }
        }
        return bestCondition;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects.size() < 3) {
            OpenGeoProver.settings.getLogger().error("There should be at least three points.");
            return false;
        }
        return true;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Points ");
        boolean bFirst = true;
        for (GeoConstruction geoCons : this.geoObjects) {
            if (!bFirst) {
                sb.append(", ");
            } else {
                bFirst = false;
            }
            sb.append(geoCons.getGeoObjectLabel());
        }
        sb.append(" are collinear");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        if (this.geoObjects.size() < 3) {
            OpenGeoProver.settings.getLogger().error("There should be at least three points.");
            return null;
        }
        Vector<AMExpression> statements = new Vector<AMExpression>();
        Point pt1 = (Point)this.geoObjects.get(0);
        Point pt2 = (Point)this.geoObjects.get(1);
        List otherPoints = this.geoObjects.subList(2, this.geoObjects.size());
        for (GeoConstruction geoCons : otherPoints) {
            Point pt = (Point)geoCons;
            AreaOfTriangle expr = new AreaOfTriangle(pt1, pt2, pt);
            statements.add(expr);
        }
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }
}

