/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.thmstatement.ThmStatement;
import java.util.HashMap;
import java.util.Vector;

public abstract class CompoundThmStatement
extends ThmStatement {
    public static final String VERSION_NUM = "1.00";
    protected Vector<ThmStatement> particleThmStatements = null;

    public Vector<ThmStatement> getParticleThmStatements() {
        return this.particleThmStatements;
    }

    public void setParticleThmStatements(Vector<ThmStatement> particleThmStatements) {
        this.particleThmStatements = particleThmStatements;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.particleThmStatements == null || this.particleThmStatements.size() == 0) {
            OpenGeoProver.settings.getLogger().error("Compound theorem statement doesn't contain particle statements");
            return false;
        }
        for (ThmStatement statement : this.particleThmStatements) {
            if (this.consProtocol != statement.getConsProtocol()) {
                OpenGeoProver.settings.getLogger().error("Found particle statement not related to theorem protocol of this compound statement.");
                return false;
            }
            if (statement.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[] getInputLabels() {
        if (this.particleThmStatements == null || this.particleThmStatements.size() == 0) {
            return null;
        }
        HashMap<String, String> labelMap = new HashMap<String, String>();
        for (ThmStatement ts : this.particleThmStatements) {
            for (String label : ts.getInputLabels()) {
                labelMap.put(label, label);
            }
        }
        if (labelMap.size() == 0) {
            return null;
        }
        String[] inputLabels = new String[labelMap.size()];
        int ii = 0;
        for (String label : labelMap.keySet()) {
            inputLabels[ii++] = label;
        }
        return inputLabels;
    }
}

