/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolySystem;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.ArrayList;
import java.util.Vector;

public class ConcurrentCircles
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";

    public ConcurrentCircles(ArrayList<Circle> circleList) {
        if (circleList == null || circleList.size() < 3) {
            OpenGeoProver.settings.getLogger().error("There should be at least three circles for statement about concurrent circles.");
            return;
        }
        this.geoObjects = new Vector();
        for (Circle c : circleList) {
            this.geoObjects.add(c);
        }
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        XPolynomial tempCond = null;
        XPolynomial tempAddend = null;
        XPolynomial bestCondition = null;
        int degreeOfBestCondition = 0;
        IntersectionPoint bestIntersectionPoint = null;
        for (GeoConstruction geoCons : this.consProtocol.getConstructionSteps()) {
            if (!(geoCons instanceof Point)) continue;
            Point P = (Point)geoCons;
            Vector<Circle> circlesHavingP = new Vector<Circle>();
            PointSetRelationshipManager manager = null;
            tempCond = new XPolynomial();
            for (GeoConstruction gc : this.geoObjects) {
                Circle c = (Circle)gc;
                if (c.getPoints().indexOf(P) < 0) continue;
                circlesHavingP.add(c);
            }
            if (circlesHavingP.size() < 2) continue;
            int numCirclesLeft = this.geoObjects.size() - circlesHavingP.size();
            for (GeoConstruction gc : this.geoObjects) {
                Circle c = (Circle)gc;
                if (circlesHavingP.indexOf(c) >= 0) continue;
                manager = new PointSetRelationshipManager(c, P, 1);
                tempAddend = manager.retrieveInstantiatedCondition();
                if (numCirclesLeft == 1) {
                    tempCond.addPolynomial(tempAddend);
                    break;
                }
                tempCond.addPolynomial(tempAddend.clone().multiplyByPolynomial(tempAddend));
                if (--numCirclesLeft != 0) continue;
                break;
            }
            int tempDegree = tempCond.getPolynomialDegree();
            if (bestCondition != null && tempDegree >= degreeOfBestCondition && (tempDegree != degreeOfBestCondition || tempCond.getTerms().size() >= bestCondition.getTerms().size())) continue;
            bestCondition = tempCond;
            degreeOfBestCondition = tempDegree;
        }
        boolean isOneCircleLeft = this.geoObjects.size() == 3;
        PointSetRelationshipManager manager = null;
        int jj1 = this.geoObjects.size();
        for (int ii1 = 0; ii1 < jj1; ++ii1) {
            Circle c1 = (Circle)this.geoObjects.get(ii1);
            int jj2 = this.geoObjects.size();
            for (int ii2 = 0; ii2 < jj2; ++ii2) {
                int ii;
                Circle c2 = (Circle)this.geoObjects.get(ii2);
                if (c2.getGeoObjectLabel().equals(c1.getGeoObjectLabel())) continue;
                tempCond = new XPolynomial();
                int numOfPolynomialsInSystem = this.consProtocol.getAlgebraicGeoTheorem().getHypotheses().getPolynomials().size();
                IntersectionPoint P = new IntersectionPoint("intersectPoint-" + c1.getGeoObjectLabel() + "." + c2.getGeoObjectLabel(), c1, c2);
                this.consProtocol.addGeoConstruction(P);
                if (!P.isValidConstructionStep()) {
                    OpenGeoProver.settings.getLogger().error("Failed to validate the construction of intersection point " + P.getGeoObjectLabel());
                    return null;
                }
                P.transformToAlgebraicFormWithOutputPrintFlag(false);
                int numOfDependentCoordinates = 0;
                if (P.getX().getVariableType() == 1) {
                    ++numOfDependentCoordinates;
                }
                if (P.getY().getVariableType() == 1) {
                    ++numOfDependentCoordinates;
                }
                int jj = this.geoObjects.size();
                for (int ii3 = 0; ii3 < jj; ++ii3) {
                    Circle c = (Circle)this.geoObjects.get(ii3);
                    if (c.getGeoObjectLabel().equals(c1.getGeoObjectLabel()) || c.getGeoObjectLabel().equals(c2.getGeoObjectLabel())) continue;
                    manager = new PointSetRelationshipManager(c, P, 1);
                    XPolynomial instantiatedCondition = manager.retrieveInstantiatedCondition();
                    if (instantiatedCondition == null) {
                        OpenGeoProver.settings.getLogger().error("Failed to retrieve the condition for point " + P.getGeoObjectLabel() + " to belong to circle " + c.getGeoObjectLabel());
                        return null;
                    }
                    tempAddend = instantiatedCondition;
                    if (isOneCircleLeft) {
                        tempCond.addPolynomial(tempAddend);
                        break;
                    }
                    tempCond.addPolynomial(tempAddend.clone().multiplyByPolynomial(tempAddend));
                }
                int tempDegree = tempCond.getPolynomialDegree();
                if (bestCondition == null || tempDegree < degreeOfBestCondition || tempDegree == degreeOfBestCondition && tempCond.getTerms().size() < bestCondition.getTerms().size()) {
                    bestCondition = tempCond;
                    degreeOfBestCondition = tempDegree;
                    bestIntersectionPoint = P;
                }
                this.consProtocol.getConstructionSteps().remove(P.getIndex());
                XPolySystem system = this.consProtocol.getAlgebraicGeoTheorem().getHypotheses();
                int jj3 = system.getPolynomials().size() - numOfPolynomialsInSystem;
                for (ii = 0; ii < jj3; ++ii) {
                    system.removePoly(system.getPolynomials().size() - 1);
                }
                for (ii = 0; ii < numOfDependentCoordinates; ++ii) {
                    this.consProtocol.decrementXIndex();
                }
            }
        }
        if (bestIntersectionPoint != null) {
            Circle c1 = (Circle)bestIntersectionPoint.getFirstPointSet();
            Circle c2 = (Circle)bestIntersectionPoint.getSecondPointSet();
            IntersectionPoint P = new IntersectionPoint("intersectPoint-" + c1.getGeoObjectLabel() + "." + c2.getGeoObjectLabel(), c1, c2);
            this.consProtocol.addGeoConstruction(P);
            if (!((GeoConstruction)P).isValidConstructionStep()) {
                OpenGeoProver.settings.getLogger().error("Failed to validate the construction of intersection point " + bestIntersectionPoint.getGeoObjectLabel());
                return null;
            }
            ((Point)P).transformToAlgebraicForm();
        }
        return bestCondition;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects.size() < 3) {
            OpenGeoProver.settings.getLogger().error("There should be at least three circles.");
            return false;
        }
        return true;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Circles ");
        boolean bFirst = true;
        for (GeoConstruction geoCons : this.geoObjects) {
            if (!bFirst) {
                sb.append(", ");
            } else {
                bFirst = false;
            }
            sb.append(geoCons.getGeoObjectLabel());
        }
        sb.append(" are concurrent");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("Statement not currently supported by the area method.");
        return null;
    }
}

