/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolySystem;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.ArrayList;
import java.util.Vector;

public class ConcurrentLines
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";

    public ConcurrentLines(ArrayList<Line> lineList) {
        if (lineList == null || lineList.size() < 3) {
            OpenGeoProver.settings.getLogger().error("There should be at least three lines for statement about concurrent lines.");
            return;
        }
        this.geoObjects = new Vector();
        for (Line l : lineList) {
            this.geoObjects.add(l);
        }
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        XPolynomial tempCond = null;
        XPolynomial tempAddend = null;
        XPolynomial bestCondition = null;
        int degreeOfBestCondition = 0;
        IntersectionPoint bestIntersectionPoint = null;
        for (GeoConstruction geoCons : this.consProtocol.getConstructionSteps()) {
            if (!(geoCons instanceof Point)) continue;
            Point P = (Point)geoCons;
            Vector<Line> linesHavingP = new Vector<Line>();
            PointSetRelationshipManager manager = null;
            tempCond = new XPolynomial();
            for (GeoConstruction gc : this.geoObjects) {
                Line l = (Line)gc;
                if (l.getPoints().indexOf(P) < 0) continue;
                linesHavingP.add(l);
            }
            if (linesHavingP.size() < 2) continue;
            int numLinesLeft = this.geoObjects.size() - linesHavingP.size();
            for (GeoConstruction gc : this.geoObjects) {
                Line l = (Line)gc;
                if (linesHavingP.indexOf(l) >= 0) continue;
                manager = new PointSetRelationshipManager(l, P, 1);
                tempAddend = manager.retrieveInstantiatedCondition();
                if (numLinesLeft == 1) {
                    tempCond.addPolynomial(tempAddend);
                    break;
                }
                tempCond.addPolynomial(tempAddend.clone().multiplyByPolynomial(tempAddend));
                if (--numLinesLeft != 0) continue;
                break;
            }
            int tempDegree = tempCond.getPolynomialDegree();
            if (bestCondition != null && tempDegree >= degreeOfBestCondition && (tempDegree != degreeOfBestCondition || tempCond.getTerms().size() >= bestCondition.getTerms().size())) continue;
            bestCondition = tempCond;
            degreeOfBestCondition = tempDegree;
        }
        boolean isOneLineLeft = this.geoObjects.size() == 3;
        PointSetRelationshipManager manager = null;
        int jj1 = this.geoObjects.size();
        for (int ii1 = 0; ii1 < jj1; ++ii1) {
            Line l1 = (Line)this.geoObjects.get(ii1);
            int jj2 = this.geoObjects.size();
            for (int ii2 = 0; ii2 < jj2; ++ii2) {
                int ii;
                Line l2 = (Line)this.geoObjects.get(ii2);
                if (l2.getGeoObjectLabel().equals(l1.getGeoObjectLabel())) continue;
                tempCond = new XPolynomial();
                int numOfPolynomialsInSystem = this.consProtocol.getAlgebraicGeoTheorem().getHypotheses().getPolynomials().size();
                IntersectionPoint P = new IntersectionPoint("intersectPoint-" + l1.getGeoObjectLabel() + "." + l2.getGeoObjectLabel(), l1, l2);
                this.consProtocol.addGeoConstruction(P);
                if (!P.isValidConstructionStep()) {
                    OpenGeoProver.settings.getLogger().error("Failed to validate the construction of intersection point " + P.getGeoObjectLabel());
                    return null;
                }
                P.transformToAlgebraicFormWithOutputPrintFlag(false);
                int numOfDependentCoordinates = 0;
                if (P.getX().getVariableType() == 1) {
                    ++numOfDependentCoordinates;
                }
                if (P.getY().getVariableType() == 1) {
                    ++numOfDependentCoordinates;
                }
                int jj = this.geoObjects.size();
                for (int ii3 = 0; ii3 < jj; ++ii3) {
                    Line l = (Line)this.geoObjects.get(ii3);
                    if (l.getGeoObjectLabel().equals(l1.getGeoObjectLabel()) || l.getGeoObjectLabel().equals(l2.getGeoObjectLabel())) continue;
                    manager = new PointSetRelationshipManager(l, P, 1);
                    XPolynomial instantiatedCondition = manager.retrieveInstantiatedCondition();
                    if (instantiatedCondition == null) {
                        OpenGeoProver.settings.getLogger().error("Failed to retrieve the condition for point " + P.getGeoObjectLabel() + " to belong to line " + l.getGeoObjectLabel());
                        return null;
                    }
                    tempAddend = instantiatedCondition;
                    if (isOneLineLeft) {
                        tempCond.addPolynomial(tempAddend);
                        break;
                    }
                    tempCond.addPolynomial(tempAddend.clone().multiplyByPolynomial(tempAddend));
                }
                int tempDegree = tempCond.getPolynomialDegree();
                if (bestCondition == null || tempDegree < degreeOfBestCondition || tempDegree == degreeOfBestCondition && tempCond.getTerms().size() < bestCondition.getTerms().size()) {
                    bestCondition = tempCond;
                    degreeOfBestCondition = tempDegree;
                    bestIntersectionPoint = P;
                }
                this.consProtocol.getConstructionSteps().remove(P.getIndex());
                l1.getPoints().remove(P);
                l2.getPoints().remove(P);
                XPolySystem system = this.consProtocol.getAlgebraicGeoTheorem().getHypotheses();
                int jj3 = system.getPolynomials().size() - numOfPolynomialsInSystem;
                for (ii = 0; ii < jj3; ++ii) {
                    system.removePoly(system.getPolynomials().size() - 1);
                }
                for (ii = 0; ii < numOfDependentCoordinates; ++ii) {
                    this.consProtocol.decrementXIndex();
                }
            }
        }
        if (bestIntersectionPoint != null) {
            Line l1 = (Line)bestIntersectionPoint.getFirstPointSet();
            Line l2 = (Line)bestIntersectionPoint.getSecondPointSet();
            IntersectionPoint P = new IntersectionPoint("intersectPoint-" + l1.getGeoObjectLabel() + "." + l2.getGeoObjectLabel(), l1, l2);
            this.consProtocol.addGeoConstruction(P);
            if (!((GeoConstruction)P).isValidConstructionStep()) {
                OpenGeoProver.settings.getLogger().error("Failed to validate the construction of intersection point " + bestIntersectionPoint.getGeoObjectLabel());
                return null;
            }
            ((Point)P).transformToAlgebraicForm();
        }
        return bestCondition;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects.size() < 3) {
            OpenGeoProver.settings.getLogger().error("There should be at least three lines.");
            return false;
        }
        return true;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Lines ");
        boolean bFirst = true;
        for (GeoConstruction geoCons : this.geoObjects) {
            if (!bFirst) {
                sb.append(", ");
            } else {
                bFirst = false;
            }
            sb.append(geoCons.getGeoObjectLabel());
        }
        sb.append(" are concurrent");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Vector<GeoConstruction> lines = this.getGeoObjects();
        Line line1 = (Line)lines.get(0);
        Line line2 = (Line)lines.get(1);
        Point a = line1.getPoints().get(0);
        Point b = line1.getPoints().get(1);
        Point c = line2.getPoints().get(0);
        Point d = line2.getPoints().get(1);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        for (int i = 2; i < lines.size(); ++i) {
            Point e = ((Line)lines.get(i)).getPoints().get(0);
            Point f = ((Line)lines.get(i)).getPoints().get(1);
            AreaOfTriangle sacd = new AreaOfTriangle(a, c, d);
            AreaOfTriangle sefb = new AreaOfTriangle(e, f, b);
            Product term1 = new Product(sacd, sefb);
            AreaOfTriangle sbcd = new AreaOfTriangle(b, c, d);
            AreaOfTriangle sefa = new AreaOfTriangle(e, f, a);
            Product term2 = new Product(sbcd, sefa);
            statements.add(new Difference(term1, term2));
        }
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }
}

