/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.CircumscribedCircle;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.ArrayList;
import java.util.Vector;

public class ConcyclicPoints
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";

    public ConcyclicPoints(ArrayList<Point> pointList) {
        if (pointList == null || pointList.size() < 4) {
            OpenGeoProver.settings.getLogger().error("There should be at least four points for statement about concyclic points.");
            return;
        }
        this.geoObjects = new Vector();
        for (Point p : pointList) {
            this.geoObjects.add(p);
        }
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        XPolynomial tempCond = null;
        XPolynomial tempAddend = null;
        XPolynomial bestCondition = null;
        int degreeOfBestCondition = 0;
        for (GeoConstruction geoCons : this.consProtocol.getConstructionSteps()) {
            if (!(geoCons instanceof Circle)) continue;
            Circle c = (Circle)geoCons;
            Vector<Point> cPoints = c.getPoints();
            ArrayList<Point> pointsFromCircle = new ArrayList<Point>();
            PointSetRelationshipManager manager = null;
            tempCond = new XPolynomial();
            for (GeoConstruction gc : this.geoObjects) {
                Point p = (Point)gc;
                if (cPoints.indexOf(p) < 0) continue;
                pointsFromCircle.add(p);
            }
            if (pointsFromCircle.size() < 3) continue;
            int numPointsLeft = this.geoObjects.size() - pointsFromCircle.size();
            for (GeoConstruction gc : this.geoObjects) {
                Point p = (Point)gc;
                if (pointsFromCircle.indexOf(p) >= 0) continue;
                manager = new PointSetRelationshipManager(c, p, 1);
                tempAddend = manager.retrieveInstantiatedCondition();
                if (numPointsLeft == 1) {
                    tempCond.addPolynomial(tempAddend);
                    break;
                }
                tempCond.addPolynomial(tempAddend.clone().multiplyByPolynomial(tempAddend));
                if (--numPointsLeft != 0) continue;
                break;
            }
            int tempDegree = tempCond.getPolynomialDegree();
            if (bestCondition != null && tempDegree >= degreeOfBestCondition && (tempDegree != degreeOfBestCondition || tempCond.getTerms().size() >= bestCondition.getTerms().size())) continue;
            bestCondition = tempCond;
            degreeOfBestCondition = tempDegree;
        }
        boolean isOnePointLeft = this.geoObjects.size() == 4;
        int jj1 = this.geoObjects.size();
        for (int ii1 = 0; ii1 < jj1; ++ii1) {
            Point p1 = (Point)this.geoObjects.get(ii1);
            int jj2 = this.geoObjects.size();
            for (int ii2 = 0; ii2 < jj2; ++ii2) {
                Point p2 = (Point)this.geoObjects.get(ii2);
                if (p2.getGeoObjectLabel().equals(p1.getGeoObjectLabel())) continue;
                int jj3 = this.geoObjects.size();
                for (int ii3 = 0; ii3 < jj3; ++ii3) {
                    Point p3 = (Point)this.geoObjects.get(ii3);
                    if (p3.getGeoObjectLabel().equals(p1.getGeoObjectLabel()) || p3.getGeoObjectLabel().equals(p2.getGeoObjectLabel())) continue;
                    CircumscribedCircle c = new CircumscribedCircle("tempCircle", p1, p2, p3);
                    tempCond = new XPolynomial();
                    int jj = this.geoObjects.size();
                    for (int ii = 0; ii < jj; ++ii) {
                        Point p = (Point)this.geoObjects.get(ii);
                        if (p.getGeoObjectLabel().equals(p1.getGeoObjectLabel()) || p.getGeoObjectLabel().equals(p2.getGeoObjectLabel()) || p.getGeoObjectLabel().equals(p3.getGeoObjectLabel())) continue;
                        tempAddend = c.instantiateConditionFromBasicElements(p);
                        if (isOnePointLeft) {
                            tempCond.addPolynomial(tempAddend);
                            break;
                        }
                        tempCond.addPolynomial(tempAddend.clone().multiplyByPolynomial(tempAddend));
                    }
                    int tempDegree = tempCond.getPolynomialDegree();
                    if (bestCondition != null && tempDegree >= degreeOfBestCondition && (tempDegree != degreeOfBestCondition || tempCond.getTerms().size() >= bestCondition.getTerms().size())) continue;
                    bestCondition = tempCond;
                    degreeOfBestCondition = tempDegree;
                }
            }
        }
        return bestCondition;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects.size() < 4) {
            OpenGeoProver.settings.getLogger().error("There should be at least four points.");
            return false;
        }
        return true;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Points ");
        boolean bFirst = true;
        for (GeoConstruction geoCons : this.geoObjects) {
            if (!bFirst) {
                sb.append(", ");
            } else {
                bFirst = false;
            }
            sb.append(geoCons.getGeoObjectLabel());
        }
        sb.append(" are concyclic");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Vector pointList = this.geoObjects;
        Vector<AMExpression> statements = new Vector<AMExpression>();
        Point a = (Point)pointList.get(0);
        Point b = (Point)pointList.get(1);
        for (int i = 4; i < pointList.size(); ++i) {
            Point c = (Point)pointList.get(i - 1);
            Point d = (Point)pointList.get(i);
            AreaOfTriangle scad = new AreaOfTriangle(c, a, d);
            AreaOfTriangle scbd = new AreaOfTriangle(c, b, d);
            PythagorasDifference pcad = new PythagorasDifference(c, a, d);
            PythagorasDifference pcbd = new PythagorasDifference(c, b, d);
            Product product1 = new Product(scad, pcbd);
            Product product2 = new Product(scbd, pcad);
            Difference difference = new Difference(product1, product2);
            statements.add(difference);
        }
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }
}

