/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.polynomials.XTerm;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.HashMap;
import java.util.Vector;

public class CongruentTriangles
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    public static String A1Label = "A1";
    public static String B1Label = "B1";
    public static String C1Label = "C1";
    public static String A2Label = "A2";
    public static String B2Label = "B2";
    public static String C2Label = "C2";
    public static SymbolicPolynomial conditionForCongTriangles = null;

    public CongruentTriangles(Point A1, Point B1, Point C1, Point A2, Point B2, Point C2) {
        this.geoObjects = new Vector();
        this.geoObjects.add(A1);
        this.geoObjects.add(B1);
        this.geoObjects.add(C1);
        this.geoObjects.add(A2);
        this.geoObjects.add(B2);
        this.geoObjects.add(C2);
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Triangles ");
        sb.append(((GeoConstruction)this.geoObjects.get(0)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(1)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(2)).getGeoObjectLabel());
        sb.append(" and ");
        sb.append(((GeoConstruction)this.geoObjects.get(3)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(4)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(5)).getGeoObjectLabel());
        sb.append(" are congruent");
        return sb.toString();
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(A1Label, (Point)this.geoObjects.get(0));
        pointsMap.put(B1Label, (Point)this.geoObjects.get(1));
        pointsMap.put(C1Label, (Point)this.geoObjects.get(2));
        pointsMap.put(A2Label, (Point)this.geoObjects.get(3));
        pointsMap.put(B2Label, (Point)this.geoObjects.get(4));
        pointsMap.put(C2Label, (Point)this.geoObjects.get(5));
        XPolynomial x1 = OGPTP.instantiateCondition(Segment.getSubstitutedConditionForSquareOfDistance(B1Label, C1Label), pointsMap);
        XPolynomial y1 = OGPTP.instantiateCondition(Segment.getSubstitutedConditionForSquareOfDistance(C1Label, A1Label), pointsMap);
        XPolynomial z1 = OGPTP.instantiateCondition(Segment.getSubstitutedConditionForSquareOfDistance(A1Label, B1Label), pointsMap);
        XPolynomial x2 = OGPTP.instantiateCondition(Segment.getSubstitutedConditionForSquareOfDistance(B2Label, C2Label), pointsMap);
        XPolynomial y2 = OGPTP.instantiateCondition(Segment.getSubstitutedConditionForSquareOfDistance(C2Label, A2Label), pointsMap);
        XPolynomial z2 = OGPTP.instantiateCondition(Segment.getSubstitutedConditionForSquareOfDistance(A2Label, B2Label), pointsMap);
        XPolynomial P = (XPolynomial)x1.clone().addPolynomial(y1).addPolynomial(z1).addPolynomial(x2).addPolynomial(y2).addPolynomial(z2);
        P.multiplyByTerm(new XTerm(0.5));
        XPolynomial Q = (XPolynomial)P.clone().multiplyByPolynomial(P);
        Q.addPolynomial(x1.clone().multiplyByPolynomial(x2));
        Q.subtractPolynomial(y1.clone().multiplyByPolynomial(y2));
        Q.subtractPolynomial(z1.clone().multiplyByPolynomial(z2));
        XPolynomial R = (XPolynomial)Q.clone().multiplyByPolynomial(Q);
        R.subtractPolynomial(P.clone().multiplyByPolynomial(P).multiplyByPolynomial(x1).multiplyByPolynomial(x2).multiplyByTerm(new XTerm(4.0)));
        R.subtractPolynomial(y1.clone().multiplyByPolynomial(y2).multiplyByPolynomial(z1).multiplyByPolynomial(z2).multiplyByTerm(new XTerm(4.0)));
        XPolynomial result = new XPolynomial(64.0);
        result.multiplyByPolynomial(P).multiplyByPolynomial(P);
        result.multiplyByPolynomial(x1);
        result.multiplyByPolynomial(x2);
        result.multiplyByPolynomial(y1);
        result.multiplyByPolynomial(y2);
        result.multiplyByPolynomial(z1);
        result.multiplyByPolynomial(z2);
        result.subtractPolynomial(R.clone().multiplyByPolynomial(R));
        return result;
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Point a = (Point)this.geoObjects.get(0);
        Point b = (Point)this.geoObjects.get(1);
        Point c = (Point)this.geoObjects.get(2);
        Point d = (Point)this.geoObjects.get(3);
        Point e = (Point)this.geoObjects.get(4);
        Point f = (Point)this.geoObjects.get(5);
        PythagorasDifference squareOfAB = new PythagorasDifference(a, b, a);
        PythagorasDifference squareOfBC = new PythagorasDifference(c, b, c);
        PythagorasDifference squareOfAC = new PythagorasDifference(a, c, a);
        PythagorasDifference squareOfDE = new PythagorasDifference(d, e, d);
        PythagorasDifference squareOfEF = new PythagorasDifference(f, e, f);
        PythagorasDifference squareOfDF = new PythagorasDifference(d, f, d);
        Difference difference1 = new Difference(squareOfAB, squareOfDE);
        Difference difference2 = new Difference(squareOfBC, squareOfEF);
        Difference difference3 = new Difference(squareOfAC, squareOfDF);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        statements.add(difference1);
        statements.add(difference2);
        statements.add(difference3);
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }

    static {
        if (conditionForCongTriangles == null) {
            // empty if block
        }
    }
}

