/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.thmstatement.ThmStatement;
import java.util.Vector;

public abstract class ElementaryThmStatement
extends ThmStatement {
    public static final String VERSION_NUM = "1.00";
    protected Vector<GeoConstruction> geoObjects = null;

    public Vector<GeoConstruction> getGeoObjects() {
        return this.geoObjects;
    }

    public void setGeoObjects(Vector<GeoConstruction> geoObjects) {
        this.geoObjects = geoObjects;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects == null || this.geoObjects.size() == 0) {
            OpenGeoProver.settings.getLogger().error("Theorem statement doesn't contain geometry objects");
            return false;
        }
        for (GeoConstruction geoCons : this.geoObjects) {
            if (this.consProtocol.getConstructionSteps().indexOf(geoCons) >= 0) continue;
            OpenGeoProver.settings.getLogger().error("Geometry object " + geoCons.getGeoObjectLabel() + " not found in list of all constructed objects.");
            return false;
        }
        return true;
    }

    @Override
    public String[] getInputLabels() {
        if (this.geoObjects == null || this.geoObjects.size() == 0) {
            return null;
        }
        String[] inputLabels = new String[this.geoObjects.size()];
        int ii = 0;
        for (GeoConstruction gc : this.geoObjects) {
            inputLabels[ii++] = gc.getGeoObjectLabel();
        }
        return inputLabels;
    }
}

