/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.GeneralizedAngleTangent;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Angle;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.Map;
import java.util.Vector;

public class EqualAngles
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private Angle firstAngle = null;
    private Angle secondAngle = null;

    public void setFirstAngle(Angle firstAngle) {
        this.firstAngle = firstAngle;
    }

    public Angle getFirstAngle() {
        return this.firstAngle;
    }

    public void setSecondAngle(Angle secondAngle) {
        this.secondAngle = secondAngle;
    }

    public Angle getSecondAngle() {
        return this.secondAngle;
    }

    public EqualAngles(Point A1, Point O1, Point B1, Point A2, Point O2, Point B2) {
        this.geoObjects = new Vector();
        this.geoObjects.add(A1);
        this.geoObjects.add(O1);
        this.geoObjects.add(B1);
        this.geoObjects.add(A2);
        this.geoObjects.add(O2);
        this.geoObjects.add(B2);
        this.firstAngle = new Angle(A1, O1, B1);
        this.secondAngle = new Angle(A2, O2, B2);
    }

    public EqualAngles(Angle firstAngle, Angle secondAngle) {
        this.firstAngle = firstAngle;
        this.secondAngle = secondAngle;
        this.geoObjects = new Vector();
        this.geoObjects.add(firstAngle.getFirstRayPoint());
        this.geoObjects.add(firstAngle.getVertex());
        this.geoObjects.add(firstAngle.getSecondRayPoint());
        this.geoObjects.add(secondAngle.getFirstRayPoint());
        this.geoObjects.add(secondAngle.getVertex());
        this.geoObjects.add(secondAngle.getSecondRayPoint());
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        Angle alpha = new Angle(((Point)this.geoObjects.get(0)).clone(), ((Point)this.geoObjects.get(1)).clone(), ((Point)this.geoObjects.get(2)).clone());
        Angle beta = new Angle(((Point)this.geoObjects.get(3)).clone(), ((Point)this.geoObjects.get(4)).clone(), ((Point)this.geoObjects.get(5)).clone());
        Map<String, Point> pointsMap = GeneralizedAngleTangent.getPointsMapForTwoAngles(alpha, beta);
        return OGPTP.instantiateCondition(GeneralizedAngleTangent.getConditionForEqualsConvexAngles(), pointsMap);
    }

    @Override
    public String getStatementDesc() {
        Angle alpha = new Angle((Point)this.geoObjects.get(0), (Point)this.geoObjects.get(1), (Point)this.geoObjects.get(2));
        Angle beta = new Angle((Point)this.geoObjects.get(3), (Point)this.geoObjects.get(4), (Point)this.geoObjects.get(5));
        StringBuilder sb = new StringBuilder();
        sb.append("Angles ");
        sb.append(alpha.getDescription());
        sb.append(" and ");
        sb.append(beta.getDescription());
        sb.append(" are equal");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Point a = (Point)this.geoObjects.get(0);
        Point b = (Point)this.geoObjects.get(1);
        Point c = (Point)this.geoObjects.get(2);
        Point d = (Point)this.geoObjects.get(3);
        Point e = (Point)this.geoObjects.get(4);
        Point f = (Point)this.geoObjects.get(5);
        AreaOfTriangle sabc = new AreaOfTriangle(a, b, c);
        AreaOfTriangle sdef = new AreaOfTriangle(d, e, f);
        PythagorasDifference pabc = new PythagorasDifference(a, b, c);
        PythagorasDifference pdef = new PythagorasDifference(d, e, f);
        Product firstProduct = new Product(sabc, pdef);
        Product secondProduct = new Product(sdef, pabc);
        Difference difference = new Difference(firstProduct, secondProduct);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        statements.add(difference);
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }
}

