/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.ElementaryThmStatement;
import java.util.HashSet;
import java.util.Vector;

public class EqualityOfExpressions
extends ElementaryThmStatement {
    public static final String VERSION_NUM = "1.00";
    private AMExpression expr1;
    private AMExpression expr2;

    public EqualityOfExpressions(AMExpression expr1, AMExpression expr2) {
        this.expr1 = expr1;
        this.expr2 = expr2;
        HashSet<Point> points = new HashSet<Point>();
        points.addAll(expr1.getPoints());
        points.addAll(expr2.getPoints());
        this.geoObjects = new Vector(points);
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        OpenGeoProver.settings.getLogger().error("Transformation to algebraic form is not yet implemented for this theorem statement.");
        return null;
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Difference difference = new Difference(this.expr1, this.expr2);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        statements.add(difference);
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Expressions ");
        sb.append(this.expr1.print());
        sb.append(" and ");
        sb.append(this.expr2.print());
        sb.append(" are equal.");
        return sb.toString();
    }
}

