/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.RatioOfTwoCollinearSegments;
import com.ogprover.pp.tp.auxiliary.RatioProduct;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.Vector;

public class EqualityOfRatioProducts
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private RatioProduct leftProduct = null;
    private RatioProduct rightProduct = null;
    private double multiplicatorFactor = 0.0;

    public void setLeftProduct(RatioProduct leftProduct) {
        this.leftProduct = leftProduct;
    }

    public RatioProduct getLeftProduct() {
        return this.leftProduct;
    }

    public void setRightProduct(RatioProduct rightProduct) {
        this.rightProduct = rightProduct;
    }

    public RatioProduct getRightProduct() {
        return this.rightProduct;
    }

    public void setMultiplicatorFactor(double multiplicatorFactor) {
        this.multiplicatorFactor = multiplicatorFactor;
    }

    public double getMultiplicatorFactor() {
        return this.multiplicatorFactor;
    }

    public EqualityOfRatioProducts(RatioProduct leftProduct, RatioProduct rightProduct, double mulCoeff) {
        Point tempP = null;
        this.leftProduct = leftProduct != null ? leftProduct : new RatioProduct();
        this.rightProduct = rightProduct != null ? rightProduct : new RatioProduct();
        this.multiplicatorFactor = mulCoeff;
        this.geoObjects = new Vector();
        if (this.leftProduct.getRatios() != null) {
            for (RatioOfTwoCollinearSegments ratio : this.leftProduct.getRatios()) {
                tempP = ratio.getNumeratorSegment().getFirstEndPoint();
                if (this.geoObjects.indexOf(tempP) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = ratio.getNumeratorSegment().getSecondEndPoint()) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = ratio.getDenominatorSegment().getFirstEndPoint()) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = ratio.getDenominatorSegment().getSecondEndPoint()) >= 0) continue;
                this.geoObjects.add(tempP);
            }
        }
        if (this.rightProduct.getRatios() != null) {
            for (RatioOfTwoCollinearSegments ratio : this.rightProduct.getRatios()) {
                tempP = ratio.getNumeratorSegment().getFirstEndPoint();
                if (this.geoObjects.indexOf(tempP) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = ratio.getNumeratorSegment().getSecondEndPoint()) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = ratio.getDenominatorSegment().getFirstEndPoint()) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = ratio.getDenominatorSegment().getSecondEndPoint()) >= 0) continue;
                this.geoObjects.add(tempP);
            }
        }
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        this.leftProduct.transformToAlgebraicForm();
        this.rightProduct.transformToAlgebraicForm();
        return (XPolynomial)this.leftProduct.getNumerator().clone().multiplyByPolynomial(this.rightProduct.getDenominator()).subtractPolynomial(this.rightProduct.getNumerator().clone().multiplyByPolynomial(this.leftProduct.getDenominator()).multiplyByRealConstant(this.multiplicatorFactor));
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ratio product ");
        boolean bFirst = true;
        for (RatioOfTwoCollinearSegments ratio : this.leftProduct.getRatios()) {
            if (!bFirst) {
                sb.append("*");
            } else {
                bFirst = false;
            }
            sb.append("(");
            sb.append(ratio.getNumeratorSegment().getDescription());
            sb.append("/");
            sb.append(ratio.getDenominatorSegment().getDescription());
            sb.append(")");
        }
        sb.append(" is equal to ");
        sb.append(this.multiplicatorFactor);
        if (this.rightProduct != null && this.rightProduct.getRatios() != null) {
            for (RatioOfTwoCollinearSegments ratio : this.rightProduct.getRatios()) {
                sb.append("*(");
                sb.append(ratio.getNumeratorSegment().getDescription());
                sb.append("/");
                sb.append(ratio.getDenominatorSegment().getDescription());
                sb.append(")");
            }
        }
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        return null;
    }
}

