/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.GeneralizedAngleTangent;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class EquilateralTriangle
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    public static final String ALabel = "A";
    public static final String BLabel = "B";
    public static final String CLabel = "C";
    public static SymbolicPolynomial conditionForEquilateralTriangle = null;

    public EquilateralTriangle(Point A, Point B, Point C) {
        this.geoObjects = new Vector();
        this.geoObjects.add(A);
        this.geoObjects.add(B);
        this.geoObjects.add(C);
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Triangle ");
        sb.append(((GeoConstruction)this.geoObjects.get(0)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(1)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(2)).getGeoObjectLabel());
        sb.append(" is equilateral.");
        return sb.toString();
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, (Point)this.geoObjects.get(0));
        pointsMap.put(BLabel, (Point)this.geoObjects.get(1));
        pointsMap.put(CLabel, (Point)this.geoObjects.get(2));
        return OGPTP.instantiateCondition(conditionForEquilateralTriangle, pointsMap);
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Point a = (Point)this.geoObjects.get(0);
        Point b = (Point)this.geoObjects.get(1);
        Point c = (Point)this.geoObjects.get(2);
        PythagorasDifference ab = new PythagorasDifference(a, b, a);
        PythagorasDifference bc = new PythagorasDifference(c, b, c);
        PythagorasDifference ac = new PythagorasDifference(a, c, a);
        Difference firstDifference = new Difference(ab, bc);
        Difference secondDifference = new Difference(ab, ac);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        statements.add(firstDifference);
        statements.add(secondDifference);
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }

    static {
        if (conditionForEquilateralTriangle == null) {
            ArrayList<SymbolicPolynomial> tgA = GeneralizedAngleTangent.getSubstitutedConditionForTangent(CLabel, ALabel, BLabel);
            ArrayList<SymbolicPolynomial> tgB = GeneralizedAngleTangent.getSubstitutedConditionForTangent(ALabel, BLabel, CLabel);
            SymbolicPolynomial nA = tgA.get(0);
            SymbolicPolynomial dA = tgA.get(1);
            SymbolicPolynomial nB = tgB.get(0);
            SymbolicPolynomial dB = tgB.get(1);
            SymbolicPolynomial X = (SymbolicPolynomial)nA.clone().multiplyByPolynomial(nA).subtractPolynomial(dA.clone().multiplyByPolynomial(dA).multiplyByTerm(new SymbolicTerm(3.0)));
            SymbolicPolynomial Y = (SymbolicPolynomial)nB.clone().multiplyByPolynomial(nB).subtractPolynomial(dB.clone().multiplyByPolynomial(dB).multiplyByTerm(new SymbolicTerm(3.0)));
            conditionForEquilateralTriangle = (SymbolicPolynomial)X.clone().multiplyByPolynomial(X).addPolynomial(Y.clone().multiplyByPolynomial(Y));
        }
    }
}

