/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.Variable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.RatioOfCollinearSegments;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.HashMap;
import java.util.Vector;

public class FourHarmonicConjugatePoints
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private static final String CLabel = "C";
    private static final String DLabel = "D";

    public FourHarmonicConjugatePoints(Point pointA, Point pointB, Point pointC, Point pointD) {
        this.geoObjects = new Vector();
        this.geoObjects.add(pointA);
        this.geoObjects.add(pointB);
        this.geoObjects.add(pointC);
        this.geoObjects.add(pointD);
    }

    private SymbolicPolynomial getXCondition() {
        SymbolicPolynomial xCondition = new SymbolicPolynomial();
        SymbolicVariable xA = new SymbolicVariable(2, ALabel);
        SymbolicVariable xB = new SymbolicVariable(2, BLabel);
        SymbolicVariable xC = new SymbolicVariable(2, CLabel);
        SymbolicVariable xD = new SymbolicVariable(2, DLabel);
        SymbolicTerm t = new SymbolicTerm(-2.0);
        t.addPower(new Power(xD, 1));
        t.addPower(new Power(xC, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(1.0);
        t.addPower(new Power(xD, 1));
        t.addPower(new Power(xB, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(1.0);
        t.addPower(new Power(xD, 1));
        t.addPower(new Power(xA, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(1.0);
        t.addPower(new Power(xC, 1));
        t.addPower(new Power(xB, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(1.0);
        t.addPower(new Power(xC, 1));
        t.addPower(new Power(xA, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(-2.0);
        t.addPower(new Power(xB, 1));
        t.addPower(new Power(xA, 1));
        xCondition.addTerm(t);
        return xCondition;
    }

    private SymbolicPolynomial getYCondition() {
        SymbolicPolynomial yCondition = new SymbolicPolynomial();
        SymbolicVariable yA = new SymbolicVariable(3, ALabel);
        SymbolicVariable yB = new SymbolicVariable(3, BLabel);
        SymbolicVariable yC = new SymbolicVariable(3, CLabel);
        SymbolicVariable yD = new SymbolicVariable(3, DLabel);
        SymbolicTerm t = new SymbolicTerm(-2.0);
        t.addPower(new Power(yD, 1));
        t.addPower(new Power(yC, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(1.0);
        t.addPower(new Power(yD, 1));
        t.addPower(new Power(yB, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(1.0);
        t.addPower(new Power(yD, 1));
        t.addPower(new Power(yA, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(1.0);
        t.addPower(new Power(yC, 1));
        t.addPower(new Power(yB, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(1.0);
        t.addPower(new Power(yC, 1));
        t.addPower(new Power(yA, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(-2.0);
        t.addPower(new Power(yB, 1));
        t.addPower(new Power(yA, 1));
        yCondition.addTerm(t);
        return yCondition;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects.size() < 4) {
            OpenGeoProver.settings.getLogger().error("There must be four points.");
            return false;
        }
        return true;
    }

    public XPolynomial getXAlgebraicForm() {
        Point A = (Point)this.getGeoObjects().get(0);
        Point B = (Point)this.getGeoObjects().get(1);
        Point C = (Point)this.getGeoObjects().get(2);
        Point D = (Point)this.getGeoObjects().get(3);
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, A);
        pointsMap.put(BLabel, B);
        pointsMap.put(CLabel, C);
        pointsMap.put(DLabel, D);
        return OGPTP.instantiateCondition(this.getXCondition(), pointsMap);
    }

    public XPolynomial getYAlgebraicForm() {
        Point A = (Point)this.getGeoObjects().get(0);
        Point B = (Point)this.getGeoObjects().get(1);
        Point C = (Point)this.getGeoObjects().get(2);
        Point D = (Point)this.getGeoObjects().get(3);
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, A);
        pointsMap.put(BLabel, B);
        pointsMap.put(CLabel, C);
        pointsMap.put(DLabel, D);
        return OGPTP.instantiateCondition(this.getYCondition(), pointsMap);
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        Point A = (Point)this.getGeoObjects().get(0);
        Point B = (Point)this.getGeoObjects().get(1);
        UXVariable xA = A.getX();
        UXVariable xB = B.getX();
        if (((Variable)xA).getVariableType() == ((Variable)xB).getVariableType() && xA.getIndex() == xB.getIndex()) {
            return this.getYAlgebraicForm();
        }
        return this.getXAlgebraicForm();
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pair of points ");
        sb.append(this.getGeoObjects().get(0).getGeoObjectLabel());
        sb.append(" and ");
        sb.append(this.getGeoObjects().get(1).getGeoObjectLabel());
        sb.append(" is in harmonic conjunction with pair of points ");
        sb.append(this.getGeoObjects().get(2).getGeoObjectLabel());
        sb.append(" and ");
        sb.append(this.getGeoObjects().get(3).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Point a = (Point)this.geoObjects.get(0);
        Point b = (Point)this.geoObjects.get(1);
        Point c = (Point)this.geoObjects.get(2);
        Point d = (Point)this.geoObjects.get(3);
        AreaOfTriangle areaOfABC = new AreaOfTriangle(a, b, c);
        AreaOfTriangle areaOfABD = new AreaOfTriangle(a, b, d);
        RatioOfCollinearSegments firstRatio = new RatioOfCollinearSegments(a, c, c, b);
        RatioOfCollinearSegments secondRatio = new RatioOfCollinearSegments(d, a, d, b);
        Difference difference = new Difference(firstRatio, secondRatio);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        statements.add(areaOfABC);
        statements.add(areaOfABD);
        statements.add(difference);
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }
}

