/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.HashMap;
import java.util.Vector;

public class IdenticalPoints
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";
    public static final String ALabel = "A";
    public static final String BLabel = "B";
    public static SymbolicPolynomial conditionForIdenticalPoints = null;

    public IdenticalPoints(Point A, Point B) {
        this.geoObjects = new Vector();
        this.geoObjects.add(A);
        this.geoObjects.add(B);
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, (Point)this.geoObjects.get(0));
        pointsMap.put(BLabel, (Point)this.geoObjects.get(1));
        return OGPTP.instantiateCondition(conditionForIdenticalPoints, pointsMap);
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Points ");
        sb.append(this.getGeoObjects().get(0).getGeoObjectLabel());
        sb.append(" and ");
        sb.append(this.getGeoObjects().get(1).getGeoObjectLabel());
        sb.append(" are identical");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Point a = (Point)this.geoObjects.get(0);
        Point b = (Point)this.geoObjects.get(1);
        PythagorasDifference pythagorasDifference = new PythagorasDifference(a, b, a);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        statements.add(pythagorasDifference);
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }

    static {
        if (conditionForIdenticalPoints == null) {
            conditionForIdenticalPoints = Segment.substitutePointLabelsForSquareOfDistance((SymbolicPolynomial)Segment.getConditionForSquareOfDistance().clone(), ALabel, BLabel);
        }
    }
}

