/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.DoubleSignedAreaOfPolygon;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.Vector;

public class LinearCombinationOfDoubleSignedPolygonAreas
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private Vector<Vector<Point>> polygons = null;
    private Vector<Double> coefficients = null;

    public void setPolygons(Vector<Vector<Point>> polygons) {
        this.polygons = polygons;
    }

    public Vector<Vector<Point>> getPolygons() {
        return this.polygons;
    }

    public void setCoefficients(Vector<Double> coefficients) {
        this.coefficients = coefficients;
    }

    public Vector<Double> getCoefficients() {
        return this.coefficients;
    }

    public LinearCombinationOfDoubleSignedPolygonAreas(Vector<Vector<Point>> polygons, Vector<Double> coefficients) {
        this.polygons = polygons;
        this.coefficients = coefficients;
        this.geoObjects = new Vector();
        for (Vector<Point> vertices : this.polygons) {
            for (Point P : vertices) {
                if (this.geoObjects.indexOf(P) >= 0) continue;
                this.geoObjects.add(P);
            }
        }
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.polygons == null || this.coefficients == null || this.polygons.size() != this.coefficients.size()) {
            OpenGeoProver.settings.getLogger().error("There must be equal number of polygons and coefficients.");
            return false;
        }
        return true;
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        XPolynomial statementPoly = new XPolynomial();
        int jj = this.polygons.size();
        for (int ii = 0; ii < jj; ++ii) {
            DoubleSignedAreaOfPolygon area = new DoubleSignedAreaOfPolygon(this.polygons.get(ii));
            statementPoly.addPolynomial(area.getAreaPolynomial().multiplyByRealConstant(this.coefficients.get(ii)));
        }
        return statementPoly;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Linear combination of double signed polygon areas: ");
        for (int ii = 0; ii < this.coefficients.size(); ++ii) {
            if (ii > 0 && this.coefficients.get(ii) > 0.0) {
                sb.append("+");
            }
            sb.append(this.coefficients.get(ii));
            sb.append("*");
            for (Point vertex : this.polygons.get(ii)) {
                sb.append(vertex.getGeoObjectLabel());
            }
        }
        sb.append(" equals zero");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("The area method does not currently use floating-point calculus.");
        return null;
    }
}

