/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.Variable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.Vector;

public class LinearCombinationOfOrientedSegments
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private Vector<Segment> segments = null;
    private Vector<Double> coefficients = null;

    public void setSegments(Vector<Segment> segments) {
        this.segments = segments;
    }

    public Vector<Segment> getSegments() {
        return this.segments;
    }

    public void setCoefficients(Vector<Double> coefficients) {
        this.coefficients = coefficients;
    }

    public Vector<Double> getCoefficients() {
        return this.coefficients;
    }

    public LinearCombinationOfOrientedSegments(Vector<Segment> segments, Vector<Double> coefficients) {
        Point tempP = null;
        this.segments = segments;
        this.coefficients = coefficients;
        this.geoObjects = new Vector();
        if (this.segments != null) {
            for (Segment seg : this.segments) {
                tempP = seg.getFirstEndPoint();
                if (this.geoObjects.indexOf(tempP) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = seg.getSecondEndPoint()) >= 0) continue;
                this.geoObjects.add(tempP);
            }
        }
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.segments == null || this.coefficients == null || this.segments.size() != this.coefficients.size()) {
            OpenGeoProver.settings.getLogger().error("There must be equal number of segments and coefficients.");
            return false;
        }
        return true;
    }

    public XPolynomial getXAlgebraicForm() {
        XPolynomial result = new XPolynomial();
        int jj = this.segments.size();
        for (int ii = 0; ii < jj; ++ii) {
            Segment currSeg = this.segments.get(ii);
            double currCoeff = this.coefficients.get(ii);
            result.addPolynomial(currSeg.getInstantiatedXCoordinateOfOrientedSegment().multiplyByRealConstant(currCoeff));
        }
        return result;
    }

    public XPolynomial getYAlgebraicForm() {
        XPolynomial result = new XPolynomial();
        int jj = this.segments.size();
        for (int ii = 0; ii < jj; ++ii) {
            Segment currSeg = this.segments.get(ii);
            double currCoeff = this.coefficients.get(ii);
            result.addPolynomial(currSeg.getInstantiatedYCoordinateOfOrientedSegment().multiplyByRealConstant(currCoeff));
        }
        return result;
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        Segment seg = this.segments.get(0);
        Point A = seg.getFirstEndPoint();
        Point B = seg.getSecondEndPoint();
        UXVariable xA = A.getX();
        UXVariable xB = B.getX();
        if (((Variable)xA).getVariableType() == ((Variable)xB).getVariableType() && xA.getIndex() == xB.getIndex()) {
            return this.getYAlgebraicForm();
        }
        return this.getXAlgebraicForm();
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Linear combination of oriented segments: ");
        for (int ii = 0; ii < this.coefficients.size(); ++ii) {
            if (ii > 0) {
                sb.append("+");
            }
            sb.append(this.coefficients.get(ii));
            sb.append("*");
            sb.append(this.segments.get(ii).getDescription());
        }
        sb.append(" equals zero");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("The area method does not currently use floating-point calculus.");
        return null;
    }
}

