/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.GeneralizedSegment;
import com.ogprover.pp.tp.auxiliary.ProductOfTwoSegments;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.Vector;

public class LinearCombinationOfSquaresOfSegments
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private Vector<GeneralizedSegment> segments = null;
    private Vector<Double> coefficients = null;

    public void setSegments(Vector<GeneralizedSegment> segments) {
        this.segments = segments;
    }

    public Vector<GeneralizedSegment> getSegments() {
        return this.segments;
    }

    public void setCoefficients(Vector<Double> coefficients) {
        this.coefficients = coefficients;
    }

    public Vector<Double> getCoefficients() {
        return this.coefficients;
    }

    public LinearCombinationOfSquaresOfSegments(Vector<GeneralizedSegment> segments, Vector<Double> coefficients) {
        Point tempP = null;
        this.segments = segments;
        this.coefficients = coefficients;
        this.geoObjects = new Vector();
        if (this.segments != null) {
            for (GeneralizedSegment genseg : this.segments) {
                if (genseg instanceof Segment) {
                    Segment seg = (Segment)genseg;
                    tempP = seg.getFirstEndPoint();
                    if (this.geoObjects.indexOf(tempP) < 0) {
                        this.geoObjects.add(tempP);
                    }
                    if (this.geoObjects.indexOf(tempP = seg.getSecondEndPoint()) >= 0) continue;
                    this.geoObjects.add(tempP);
                    continue;
                }
                if (!(genseg instanceof ProductOfTwoSegments)) continue;
                ProductOfTwoSegments prodseg = (ProductOfTwoSegments)genseg;
                Segment seg1 = prodseg.getFirstSegment();
                Segment seg2 = prodseg.getSecondSegment();
                tempP = seg1.getFirstEndPoint();
                if (this.geoObjects.indexOf(tempP) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = seg1.getSecondEndPoint()) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = seg2.getFirstEndPoint()) < 0) {
                    this.geoObjects.add(tempP);
                }
                if (this.geoObjects.indexOf(tempP = seg2.getSecondEndPoint()) >= 0) continue;
                this.geoObjects.add(tempP);
            }
        }
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        XPolynomial statementPoly = new XPolynomial();
        int ii = 0;
        for (GeneralizedSegment genseg : this.segments) {
            double coeff;
            double d = coeff = this.coefficients != null && this.coefficients.get(ii) != null ? this.coefficients.get(ii) : 1.0;
            if (genseg instanceof Segment) {
                Segment seg = (Segment)genseg;
                XPolynomial segpoly = seg.getInstantiatedConditionForSquareOfSegment();
                statementPoly.addPolynomial(segpoly.multiplyByRealConstant(coeff));
            } else if (genseg instanceof ProductOfTwoSegments) {
                ProductOfTwoSegments prodseg = (ProductOfTwoSegments)genseg;
                Segment seg1 = prodseg.getFirstSegment();
                Segment seg2 = prodseg.getSecondSegment();
                XPolynomial segpoly1 = seg1.getInstantiatedConditionForSquareOfSegment();
                XPolynomial segpoly2 = seg2.getInstantiatedConditionForSquareOfSegment();
                statementPoly.addPolynomial(segpoly1.multiplyByPolynomial(segpoly2).multiplyByRealConstant(coeff));
            }
            ++ii;
        }
        return statementPoly;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Linear combination of squares of segments: \n");
        for (int ii = 0; ii < this.coefficients.size(); ++ii) {
            if (ii > 0 && this.coefficients.get(ii) > 0.0) {
                sb.append("+");
            }
            sb.append(this.coefficients.get(ii));
            sb.append("*sqr(");
            sb.append(this.segments.get(ii).getDescription());
            sb.append(")\n");
        }
        sb.append(" equals zero");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("The area method does not currently use floating-point calculus.");
        return null;
    }
}

