/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndPoint;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.Vector;

public class PointOnSetOfPoints
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";

    public PointOnSetOfPoints(SetOfPoints set, Point P) {
        this.geoObjects = new Vector();
        this.geoObjects.add((GeoConstruction)((Object)set));
        this.geoObjects.add(P);
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        Point P;
        SetOfPoints set = (SetOfPoints)this.geoObjects.get(0);
        PointSetRelationshipManager manager = new PointSetRelationshipManager(set, P = (Point)this.geoObjects.get(1), 1);
        XPolynomial instantiatedCondition = manager.retrieveInstantiatedCondition();
        if (instantiatedCondition == null) {
            OpenGeoProver.settings.getLogger().error("Failed to instantiate the condition");
            return null;
        }
        return instantiatedCondition;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Point ");
        sb.append(((GeoConstruction)this.geoObjects.get(1)).getGeoObjectLabel());
        sb.append(" lies on set of points ");
        sb.append(((GeoConstruction)this.geoObjects.get(0)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        SetOfPoints set = (SetOfPoints)this.geoObjects.get(0);
        Point p = (Point)this.geoObjects.get(1);
        if (set instanceof Line) {
            Point a = ((LineThroughTwoPoints)set).getPoints().get(0);
            Point b = ((LineThroughTwoPoints)set).getPoints().get(1);
            AreaOfTriangle areaOfABP = new AreaOfTriangle(a, b, p);
            Vector<AMExpression> statements = new Vector<AMExpression>();
            statements.add(areaOfABP);
            return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
        }
        if (set instanceof Circle) {
            Point center = ((CircleWithCenterAndPoint)set).getCenter();
            Point pointOnCircle = ((CircleWithCenterAndPoint)set).getPoints().get(0);
            PythagorasDifference squareOfRadius = new PythagorasDifference(center, pointOnCircle, center);
            PythagorasDifference squareOfDistanceToP = new PythagorasDifference(center, p, center);
            Difference difference = new Difference(squareOfDistanceToP, squareOfRadius);
            Vector<AMExpression> statements = new Vector<AMExpression>();
            statements.add(difference);
            return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
        }
        return null;
    }
}

