/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.Variable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.HashMap;
import java.util.Vector;

public class RatioOfOrientedSegments
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private static final String CLabel = "C";
    private static final String DLabel = "D";
    private Segment firstSegment = null;
    private Segment secondSegment = null;
    private double ratioCoefficient = 0.0;

    public void setFirstSegment(Segment firstSegment) {
        this.firstSegment = firstSegment;
    }

    public Segment getFirstSegment() {
        return this.firstSegment;
    }

    public void setSecondSegment(Segment secondSegment) {
        this.secondSegment = secondSegment;
    }

    public Segment getSecondSegment() {
        return this.secondSegment;
    }

    public void setRatioCoefficient(double ratioCoefficient) {
        this.ratioCoefficient = ratioCoefficient;
    }

    public double getRatioCoefficient() {
        return this.ratioCoefficient;
    }

    public RatioOfOrientedSegments(Segment firstSegment, Segment secondSegment, double ratioCoeff) {
        this.geoObjects = new Vector();
        this.geoObjects.add(firstSegment.getFirstEndPoint());
        this.geoObjects.add(firstSegment.getSecondEndPoint());
        this.geoObjects.add(secondSegment.getFirstEndPoint());
        this.geoObjects.add(secondSegment.getSecondEndPoint());
        this.firstSegment = firstSegment;
        this.secondSegment = secondSegment;
        this.ratioCoefficient = ratioCoeff;
    }

    private SymbolicPolynomial getXCondition() {
        SymbolicPolynomial xCondition = new SymbolicPolynomial();
        SymbolicVariable xA = new SymbolicVariable(2, ALabel);
        SymbolicVariable xB = new SymbolicVariable(2, BLabel);
        SymbolicVariable xC = new SymbolicVariable(2, CLabel);
        SymbolicVariable xD = new SymbolicVariable(2, DLabel);
        SymbolicTerm t = new SymbolicTerm(1.0);
        t.addPower(new Power(xA, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(-1.0);
        t.addPower(new Power(xB, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(-this.ratioCoefficient);
        t.addPower(new Power(xC, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(this.ratioCoefficient);
        t.addPower(new Power(xD, 1));
        xCondition.addTerm(t);
        return xCondition;
    }

    private SymbolicPolynomial getYCondition() {
        SymbolicPolynomial yCondition = new SymbolicPolynomial();
        SymbolicVariable yA = new SymbolicVariable(3, ALabel);
        SymbolicVariable yB = new SymbolicVariable(3, BLabel);
        SymbolicVariable yC = new SymbolicVariable(3, CLabel);
        SymbolicVariable yD = new SymbolicVariable(3, DLabel);
        SymbolicTerm t = new SymbolicTerm(1.0);
        t.addPower(new Power(yA, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(-1.0);
        t.addPower(new Power(yB, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(-this.ratioCoefficient);
        t.addPower(new Power(yC, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(this.ratioCoefficient);
        t.addPower(new Power(yD, 1));
        yCondition.addTerm(t);
        return yCondition;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects.size() < 4) {
            OpenGeoProver.settings.getLogger().error("There must be 4 points.");
            return false;
        }
        return true;
    }

    public XPolynomial getXAlgebraicForm() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, (Point)this.geoObjects.get(0));
        pointsMap.put(BLabel, (Point)this.geoObjects.get(1));
        pointsMap.put(CLabel, (Point)this.geoObjects.get(2));
        pointsMap.put(DLabel, (Point)this.geoObjects.get(3));
        return OGPTP.instantiateCondition(this.getXCondition(), pointsMap);
    }

    public XPolynomial getYAlgebraicForm() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, (Point)this.geoObjects.get(0));
        pointsMap.put(BLabel, (Point)this.geoObjects.get(1));
        pointsMap.put(CLabel, (Point)this.geoObjects.get(2));
        pointsMap.put(DLabel, (Point)this.geoObjects.get(3));
        return OGPTP.instantiateCondition(this.getYCondition(), pointsMap);
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        UXVariable xA = this.firstSegment.getFirstEndPoint().getX();
        UXVariable xB = this.firstSegment.getSecondEndPoint().getX();
        UXVariable xC = this.secondSegment.getFirstEndPoint().getX();
        UXVariable xD = this.secondSegment.getSecondEndPoint().getX();
        UXVariable yA = this.firstSegment.getFirstEndPoint().getY();
        UXVariable yB = this.firstSegment.getSecondEndPoint().getY();
        UXVariable yC = this.secondSegment.getFirstEndPoint().getY();
        UXVariable yD = this.secondSegment.getSecondEndPoint().getY();
        if (((Variable)xA).getVariableType() == ((Variable)xB).getVariableType() && xA.getIndex() == xB.getIndex()) {
            if (((Variable)xC).getVariableType() != ((Variable)xD).getVariableType() || xC.getIndex() != xD.getIndex()) {
                OpenGeoProver.settings.getLogger().error("Second segment is not perpendicular to x-axis while first is - they have to be collinear segments.");
                return null;
            }
        } else if (((Variable)xC).getVariableType() == ((Variable)xD).getVariableType() && xC.getIndex() == xD.getIndex()) {
            OpenGeoProver.settings.getLogger().error("First segment is not perpendicular to x-axis while second is - they have to be collinear segments.");
            return null;
        }
        if (((Variable)yA).getVariableType() == ((Variable)yB).getVariableType() && yA.getIndex() == yB.getIndex()) {
            if (((Variable)yC).getVariableType() != ((Variable)yD).getVariableType() || yC.getIndex() != yD.getIndex()) {
                OpenGeoProver.settings.getLogger().error("Second segment is not perpendicular to y-axis while first is - they have to be collinear segments.");
                return null;
            }
        } else if (((Variable)yC).getVariableType() == ((Variable)yD).getVariableType() && yC.getIndex() == yD.getIndex()) {
            OpenGeoProver.settings.getLogger().error("First segment is not perpendicular to y-axis while second is - they have to be collinear segments.");
            return null;
        }
        if (((Variable)xA).getVariableType() == ((Variable)xB).getVariableType() && xA.getIndex() == xB.getIndex()) {
            return this.getYAlgebraicForm();
        }
        return this.getXAlgebraicForm();
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ratio of oriented segments ");
        sb.append(this.firstSegment.getDescription());
        sb.append("/");
        sb.append(this.secondSegment.getDescription());
        sb.append(" equals ");
        sb.append(this.ratioCoefficient);
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("The area method does not currently use floating-point calculus.");
        return null;
    }
}

