/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.Vector;

public class RatioOfTwoSegments
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private Segment firstSegment = null;
    private Segment secondSegment = null;
    private double ratioCoefficient = 0.0;

    public void setFirstSegment(Segment firstSegment) {
        this.firstSegment = firstSegment;
    }

    public Segment getFirstSegment() {
        return this.firstSegment;
    }

    public void setSecondSegment(Segment secondSegment) {
        this.secondSegment = secondSegment;
    }

    public Segment getSecondSegment() {
        return this.secondSegment;
    }

    public void setRatioCoefficient(double ratioCoefficient) {
        this.ratioCoefficient = ratioCoefficient;
    }

    public double getRatioCoefficient() {
        return this.ratioCoefficient;
    }

    public RatioOfTwoSegments(Segment firstSegment, Segment secondSegment, double ratioCoeff) {
        this.geoObjects = new Vector();
        this.geoObjects.add(firstSegment.getFirstEndPoint());
        this.geoObjects.add(firstSegment.getSecondEndPoint());
        this.geoObjects.add(secondSegment.getFirstEndPoint());
        this.geoObjects.add(secondSegment.getSecondEndPoint());
        this.firstSegment = firstSegment;
        this.secondSegment = secondSegment;
        this.ratioCoefficient = ratioCoeff;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects.size() < 4) {
            OpenGeoProver.settings.getLogger().error("There must be 4 points.");
            return false;
        }
        return true;
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        return (XPolynomial)this.firstSegment.getInstantiatedConditionForSquareOfSegment().subtractPolynomial(this.secondSegment.getInstantiatedConditionForSquareOfSegment().multiplyByRealConstant(this.ratioCoefficient * this.ratioCoefficient));
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ratio of two segments ");
        sb.append(this.firstSegment.getDescription());
        sb.append("/");
        sb.append(this.secondSegment.getDescription());
        sb.append(" equals ");
        sb.append(this.ratioCoefficient);
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("The area method does not currently use floating-point calculus.");
        return null;
    }
}

