/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.HashMap;
import java.util.Vector;

public class SegmentsOfEqualLengths
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    public static final String ALabel = "A";
    public static final String BLabel = "B";
    public static final String CLabel = "C";
    public static final String DLabel = "D";
    public static SymbolicPolynomial conditionForSegmentsOfEqualLengths = null;

    public SegmentsOfEqualLengths(Point A, Point B, Point C, Point D) {
        this.geoObjects = new Vector();
        this.geoObjects.add(A);
        this.geoObjects.add(B);
        this.geoObjects.add(C);
        this.geoObjects.add(D);
    }

    public SegmentsOfEqualLengths(Segment seg1, Segment seg2) {
        this(seg1.getFirstEndPoint(), seg1.getSecondEndPoint(), seg2.getFirstEndPoint(), seg2.getSecondEndPoint());
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, (Point)this.geoObjects.get(0));
        pointsMap.put(BLabel, (Point)this.geoObjects.get(1));
        pointsMap.put(CLabel, (Point)this.geoObjects.get(2));
        pointsMap.put(DLabel, (Point)this.geoObjects.get(3));
        return OGPTP.instantiateCondition(conditionForSegmentsOfEqualLengths, pointsMap);
    }

    @Override
    public String getStatementDesc() {
        Segment firstSeg = new Segment((Point)this.geoObjects.get(0), (Point)this.geoObjects.get(1));
        Segment secondSeg = new Segment((Point)this.geoObjects.get(2), (Point)this.geoObjects.get(3));
        StringBuilder sb = new StringBuilder();
        sb.append("Segments ");
        sb.append(firstSeg.getDescription());
        sb.append(" and ");
        sb.append(secondSeg.getDescription());
        sb.append(" have equal lengths");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Point a = (Point)this.geoObjects.get(0);
        Point b = (Point)this.geoObjects.get(1);
        Point c = (Point)this.geoObjects.get(2);
        Point d = (Point)this.geoObjects.get(3);
        PythagorasDifference squareOfAB = new PythagorasDifference(a, b, a);
        PythagorasDifference squareOfCD = new PythagorasDifference(c, d, c);
        Difference difference = new Difference(squareOfAB, squareOfCD);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        statements.add(difference);
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }

    static {
        if (conditionForSegmentsOfEqualLengths == null) {
            SymbolicPolynomial sdAB = Segment.substitutePointLabelsForSquareOfDistance((SymbolicPolynomial)Segment.getConditionForSquareOfDistance().clone(), ALabel, BLabel);
            SymbolicPolynomial sdCD = Segment.substitutePointLabelsForSquareOfDistance((SymbolicPolynomial)Segment.getConditionForSquareOfDistance().clone(), CLabel, DLabel);
            conditionForSegmentsOfEqualLengths = (SymbolicPolynomial)sdAB.subtractPolynomial(sdCD);
        }
    }
}

