/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.GeneralizedAngleTangent;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.DimensionThmStatement;
import java.util.HashMap;
import java.util.Vector;

public class SimilarTriangles
extends DimensionThmStatement {
    public static final String VERSION_NUM = "1.00";
    public static final String A1Label = "A1";
    public static final String B1Label = "B1";
    public static final String C1Label = "C1";
    public static final String A2Label = "A2";
    public static final String B2Label = "B2";
    public static final String C2Label = "C2";
    public boolean trianglesOfSameOrientation = true;
    public static SymbolicPolynomial conditionForSimilarTrianglesWithSameOrientation;
    public static SymbolicPolynomial conditionForSimilarTrianglesWithOppositeOrientation;

    public boolean areTrianglesOfSameOrientation() {
        return this.trianglesOfSameOrientation;
    }

    public void setTrianglesOfSameOrientationFlag(boolean trianglesOfSameOrientationFlag) {
        this.trianglesOfSameOrientation = trianglesOfSameOrientationFlag;
    }

    public SimilarTriangles(Point A1, Point B1, Point C1, Point A2, Point B2, Point C2, boolean areOfSameOrientation) {
        this.geoObjects = new Vector();
        this.geoObjects.add(A1);
        this.geoObjects.add(B1);
        this.geoObjects.add(C1);
        this.geoObjects.add(A2);
        this.geoObjects.add(B2);
        this.geoObjects.add(C2);
        this.trianglesOfSameOrientation = areOfSameOrientation;
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(A1Label, ((Point)this.geoObjects.get(0)).clone());
        pointsMap.put(B1Label, ((Point)this.geoObjects.get(1)).clone());
        pointsMap.put(C1Label, ((Point)this.geoObjects.get(2)).clone());
        pointsMap.put(A2Label, ((Point)this.geoObjects.get(3)).clone());
        pointsMap.put(B2Label, ((Point)this.geoObjects.get(4)).clone());
        pointsMap.put(C2Label, ((Point)this.geoObjects.get(5)).clone());
        if (this.trianglesOfSameOrientation) {
            return OGPTP.instantiateCondition(conditionForSimilarTrianglesWithSameOrientation, pointsMap);
        }
        return OGPTP.instantiateCondition(conditionForSimilarTrianglesWithOppositeOrientation, pointsMap);
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Triangles ");
        sb.append(((GeoConstruction)this.geoObjects.get(0)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(1)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(2)).getGeoObjectLabel());
        sb.append(" and ");
        sb.append(((GeoConstruction)this.geoObjects.get(3)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(4)).getGeoObjectLabel());
        sb.append(((GeoConstruction)this.geoObjects.get(5)).getGeoObjectLabel());
        sb.append(" are similar");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        Point a = (Point)this.geoObjects.get(0);
        Point b = (Point)this.geoObjects.get(1);
        Point c = (Point)this.geoObjects.get(2);
        Point d = (Point)this.geoObjects.get(3);
        Point e = (Point)this.geoObjects.get(4);
        Point f = (Point)this.geoObjects.get(5);
        AreaOfTriangle sabc = new AreaOfTriangle(a, b, c);
        AreaOfTriangle sdef = new AreaOfTriangle(d, e, f);
        PythagorasDifference pabc = new PythagorasDifference(a, b, c);
        PythagorasDifference pbca = new PythagorasDifference(b, c, a);
        PythagorasDifference pcab = new PythagorasDifference(c, a, b);
        PythagorasDifference pdef = new PythagorasDifference(d, e, f);
        PythagorasDifference pefd = new PythagorasDifference(e, f, d);
        PythagorasDifference pfde = new PythagorasDifference(f, d, e);
        Product product1 = new Product(sabc, pdef);
        Product product1bis = new Product(sdef, pabc);
        Product product2 = new Product(sabc, pefd);
        Product product2bis = new Product(sdef, pbca);
        Product product3 = new Product(sabc, pfde);
        Product product3bis = new Product(sdef, pcab);
        Difference difference1 = new Difference(product1, product1bis);
        Difference difference2 = new Difference(product2, product2bis);
        Difference difference3 = new Difference(product3, product3bis);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        statements.add(difference1);
        statements.add(difference2);
        statements.add(difference3);
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }

    static {
        SymbolicPolynomial gammaAngles;
        SymbolicPolynomial betaAngles;
        conditionForSimilarTrianglesWithSameOrientation = null;
        conditionForSimilarTrianglesWithOppositeOrientation = null;
        if (conditionForSimilarTrianglesWithSameOrientation == null) {
            betaAngles = GeneralizedAngleTangent.substitutePointLabelsForTwoAngles((SymbolicPolynomial)GeneralizedAngleTangent.getConditionForEqualsConvexAngles().clone(), A1Label, B1Label, C1Label, A2Label, B2Label, C2Label);
            gammaAngles = GeneralizedAngleTangent.substitutePointLabelsForTwoAngles((SymbolicPolynomial)GeneralizedAngleTangent.getConditionForEqualsConvexAngles().clone(), B1Label, C1Label, A1Label, B2Label, C2Label, A2Label);
            conditionForSimilarTrianglesWithSameOrientation = (SymbolicPolynomial)betaAngles.clone().multiplyByPolynomial(betaAngles);
            conditionForSimilarTrianglesWithSameOrientation.addPolynomial(gammaAngles.clone().multiplyByPolynomial(gammaAngles));
        }
        if (conditionForSimilarTrianglesWithOppositeOrientation == null) {
            betaAngles = GeneralizedAngleTangent.substitutePointLabelsForTwoAngles((SymbolicPolynomial)GeneralizedAngleTangent.getConditionForSupplementaryConvexAngles().clone(), A1Label, B1Label, C1Label, A2Label, B2Label, C2Label);
            gammaAngles = GeneralizedAngleTangent.substitutePointLabelsForTwoAngles((SymbolicPolynomial)GeneralizedAngleTangent.getConditionForSupplementaryConvexAngles().clone(), B1Label, C1Label, A1Label, B2Label, C2Label, A2Label);
            conditionForSimilarTrianglesWithOppositeOrientation = (SymbolicPolynomial)betaAngles.clone().multiplyByPolynomial(betaAngles);
            conditionForSimilarTrianglesWithOppositeOrientation.addPolynomial(gammaAngles.clone().multiplyByPolynomial(gammaAngles));
        }
    }
}

