/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;

public abstract class ThmStatement {
    public static final String VERSION_NUM = "1.00";
    protected OGPTP consProtocol = null;

    public abstract XPolynomial getAlgebraicForm();

    public abstract AreaMethodTheoremStatement getAreaMethodStatement();

    public abstract String getStatementDesc();

    public abstract String[] getInputLabels();

    public OGPTP getConsProtocol() {
        return this.consProtocol;
    }

    public void setConsProtocol(OGPTP consProtocol) {
        this.consProtocol = consProtocol;
    }

    public boolean isValid() {
        boolean valid;
        boolean bl = valid = this.consProtocol != null;
        if (!valid) {
            OpenGeoProver.settings.getLogger().error("Theorem statement is invalid because it is not added to theorem protocol.");
        }
        return valid;
    }

    public int transformToAlgebraicForm() {
        XPolynomial statementPoly = this.getAlgebraicForm();
        if (statementPoly == null) {
            return -1;
        }
        this.consProtocol.getAlgebraicGeoTheorem().setStatement(statementPoly.reduceByUTermDivision());
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        try {
            output.openEnum("itemize");
            output.openItem();
            output.writePlainText("Polynomial for theorem statement:");
            output.writePolynomial(statementPoly);
            output.closeItem();
            output.closeEnum("itemize");
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }
}

